<?php
$accordionList =  $settings['tj_accordion_list'] ?? [];
$accordion_id  = $this->get_id();

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$accordionClass = "accordion tj-faq-style h7-faq-style";
if (!empty($tjAnimation)) {
  $accordionClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-accordion-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-accordion-arg', 'class', $accordionClass);
?>

<?php if (!empty($accordionList)): ?>
  <div <?php $this->print_render_attribute_string('tj-accordion-arg'); ?> id="faqOne-<?php echo esc_attr($accordion_id); ?>">

    <?php foreach ($accordionList as $key => $item):
      $isExpand = $item['is_expand'];
      $question = $item['tj_accordion_question'];
      $answer = $item['tj_accordion_answer'];
    ?>
      <div class="accordion-item tj-faq-item <?php echo esc_attr($isExpand === 'yes' ? 'active' : ''); ?>">
        <!-- button -->
        <button class="accordion-button <?php echo esc_attr($isExpand === 'yes' ? '' : 'collapsed'); ?>" data-bs-toggle="collapse" data-bs-target="#faq-1-<?php echo esc_attr($accordion_id . "-" . ($key + 1)); ?>"
          aria-expanded="<?php echo esc_attr($isExpand === 'yes' ? 'true' : 'false'); ?>">
          <span><?php echo str_pad($key + 1, 2, '0', STR_PAD_LEFT) . "."; ?></span> <?php echo tj_kses($question); ?>
        </button>
        <!-- content -->
        <div id="faq-1-<?php echo esc_attr($accordion_id . "-" . ($key + 1)); ?>" class="accordion-collapse collapse <?php echo esc_attr($isExpand === 'yes' ? 'show' : ''); ?>" data-bs-parent="#faqOne-<?php echo esc_attr($accordion_id); ?>">
          <div class="accordion-body">
            <p><?php echo tj_kses($answer); ?></p>
          </div>
        </div>
      </div>
    <?php endforeach; ?>

  </div>
<?php endif; ?>