<?php
$accordionList =  $settings['tj_accordion_list'] ?? [];
$accordion_id  = $this->get_id();

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$accordionClass = "h6-insight_accordion h10-about-accordion";
if (!empty($tjAnimation)) {
  $accordionClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-accordion-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-accordion-arg', 'class', $accordionClass);
?>

<?php if (!empty($accordionList)): ?>
  <div <?php $this->print_render_attribute_string('tj-accordion-arg'); ?> id="about-<?php echo esc_attr($accordion_id); ?>">
    <?php foreach ($accordionList as $key => $item):
      $isExpand = $item['is_expand'];
      $question = $item['tj_accordion_question'];
      $answer = $item['tj_accordion_answer'];
    ?>
      <div class="accordion_item tj-faq-item <?php echo esc_attr($isExpand === 'yes' ? 'active' : ''); ?>">
        <button class="accordion_title <?php echo esc_attr($isExpand === 'yes' ? '' : 'collapsed'); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#about-<?php echo esc_attr($accordion_id . "-" . ($key + 1)); ?>"
          aria-expanded="<?php echo esc_attr($isExpand === 'yes' ? 'true' : 'false'); ?>">
          <span class="subtitle"><?php echo str_pad($key + 1, 2, '0', STR_PAD_LEFT) . "."; ?></span>
          <span class="title"><?php echo tj_kses($question); ?></span>
        </button>
        <div id="about-<?php echo esc_attr($accordion_id . "-" . ($key + 1)); ?>" class="accordion_desc collapse <?php echo esc_attr($isExpand === 'yes' ? 'show' : ''); ?>" data-bs-parent="#about-<?php echo esc_attr($accordion_id); ?>">
          <div class="accordion-body">
            <?php echo tj_kses($answer); ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>