<?php
$tabsContent = $settings['tj_tab_list'] ?? '';
$tab_id  = $this->get_id();

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$tabClass = "h6-team-wrapper";
if (!empty($tjAnimation)) {
  $tabClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-tab-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-tab-arg', 'class', $tabClass);
?>

<div <?php $this->print_render_attribute_string('tj-tab-arg'); ?>>
  <div class="h6-tabs team-tab-slider swiper swiper-container" id="tabCarousel-<?php echo esc_attr($tab_id); ?>">
    <div class="swiper-wrapper">
      <?php foreach ($tabsContent as $key => $tab) : ?>
        <div class="swiper-slide">
          <div class="h6-tab <?php echo esc_attr("yes" == $tab['is_tab_active'] ? "active" : ""); ?>" data-index="<?php echo esc_attr($key); ?>">
            <div class="h6-tab-image">
              <img src="<?php echo esc_url($tab['tj_content_img']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tab['tj_content_img']['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="h6-tab-content-wrap">
    <?php foreach ($tabsContent as $key => $content) : ?>
      <div class="h6-tab-content <?php echo esc_attr("yes" == $content['is_tab_active'] ? "active" : ""); ?>" id="tab-<?php echo esc_attr($key); ?>">
        <?php echo \Elementor\Plugin::instance()->frontend->get_builder_content($content['tj_get_template'], true); ?>
      </div>
    <?php endforeach; ?>
  </div>
</div>