<?php

// title
$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "h1";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "hero-title hero-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif ($tj_gsap_animation) {
  $titleClass = "hero-title hero-el-title text-anim";
} else {
  $titleClass = "hero-title hero-el-title";
}

$this->add_render_attribute('title_args', 'class', $titleClass);


// desc
$tjBannerDesc = $settings['tj_banner_desc'] ?? "";
$tjDescAnimation = $settings['tj_desc_animation'] ?? '';
$tjDescAnimationName = $settings['tj_desc_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_desc_animation_delay'] ?? '';

$descClass = "desc hero-el-desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', $tjDescAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// image
$bannerImage = $settings['tj_banner_image'] ?? '';
$bannerbgImage = $settings['tj_banner_bgimage'] ?? '';

$tjimgAnimation      = $settings['tj_img_animation'] ?? '';
$tjimgAnimationName  = $settings['tj_img_animation_name'] ?? '';
$tjimgAnimationDelay = $settings['tj_img_animation_delay'] ?? '';

if (!empty($tjimgAnimation)) {
  $imageClass = "hero-images-box-three wow $tjimgAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', $tjimgAnimationDelay['size'] . "s");
} else {
  $imageClass = "hero-images-box-three";
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// button
$tjButtonShow = $settings['tj_button_show'] ?? '';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';
$heroBtnwrap = "btn-area";
if (!empty($tjButtonAnimation)) {
  $heroBtnwrap .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg2', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_button_arg2', 'class', $heroBtnwrap);

$btnClass = "tj-primary-btn hero-button";
if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
$this->add_render_attribute('tj_button_arg', 'class', $btnClass);


$client_list   = (!empty($settings['client_list'])) ? $settings['client_list'] : "";

$counters = !empty($settings['tj_counter_list']) ? $settings['tj_counter_list'] : [];

?>

<!-- start: Banner -->
<section class="tj-hero-section-three el-section">
  <div class="container">
    <div class="row">
      <div class="hero-wrapper-three">
        <div class="hero-content-area">
          <div class="hero-content-three">
            <?php
            if (!empty($tjSectionTitle)) :
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($tjSectionTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($tjSectionTitle)
              );
            endif;
            ?>
            <?php if (!empty($tjBannerDesc)) : ?>
              <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
                <?php echo tj_kses($tjBannerDesc); ?>
              </div>
            <?php endif; ?>
            <div <?php echo $this->get_render_attribute_string('tj_button_arg2'); ?>>
              <?php if (!empty($tjButtonShow)): ?>
                <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                  <div class="btn_inner">
                    <?php if (!empty($tjBtnIcon['value'])): ?>
                      <div class="btn_icon">
                        <span>
                          <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                          <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                        </span>
                      </div>
                    <?php endif; ?>
                    <div class="btn_text">
                      <span><?php echo tj_kses($tjBtnText); ?></span>
                    </div>
                  </div>
                </a>
              <?php endif; ?>
              <?php if (!empty($client_list)): ?>
                <div class="client-experience">
                  <ul class="images-thumb">
                    <?php foreach ($client_list as $key => $client):
                      $image = $client['client_image'];

                      $tjAnimation      = $client['tj_canimation'] ?? '';
                      $tjAnimationName  = $client['tj_canimation_name'] ?? '';
                      $tjAnimationDelay   = $client['tj_canimation_delay'] ?? '';
                      $client_arg = 'tj_client_arg-' . $key;
                      if (!empty($tjAnimation)) {
                        $class = "wow $tjAnimationName";
                        $this->add_render_attribute($client_arg, 'data-wow-delay', $tjAnimationDelay['size'] . "s");
                      } else {
                        $class = "";
                      }
                      $this->add_render_attribute($client_arg, 'class', $class);

                    ?>
                      <?php if (!empty($image['url'])) : ?>
                        <li <?php echo $this->get_render_attribute_string($client_arg); ?>>
                          <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>" />
                        </li>
                      <?php endif; ?>
                    <?php endforeach; ?>
                  </ul>
                </div>
              <?php endif; ?>
            </div>
            <?php if (!empty($tj_shape_image)): ?>
              <span class="shape-1 zoominout">
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shapes/h4-hero-shape-2.svg" alt="Shapes">
              </span>
            <?php endif; ?>
          </div>
          <?php if (!empty($tj_show_counter)): ?>
            <!-- counter -->
            <div class="hero-funfact d-lg-flex d-none wow fadeInUp" data-wow-delay="0.3s" <?php if (!empty($tj_counter_image['url'])) { ?> data-bg-image="<?php echo esc_url($tj_counter_image['url']); ?>" <?php } ?>>

              <?php if (count($counters) > 0): ?>
                <?php foreach ($counters as $item):
                  $tjCounterCount = (!empty($item['tj_ff_number'])) ? $item['tj_ff_number'] : "";
                  $tjCounterPrefix = (!empty($item['tj_ff_prefix'])) ? $item['tj_ff_prefix'] : "";
                  $tjCounterSuffix = (!empty($item['tj_ff_suffix'])) ? $item['tj_ff_suffix'] : "";
                  $tjCounterTitle = (!empty($item['tj_ff_title'])) ? $item['tj_ff_title'] : "";
                ?>
                  <div class="counter-item">
                    <div class="number">
                      <span><?php echo esc_html($tjCounterPrefix); ?></span>
                      <span class="odometer" data-count="<?php echo esc_html($tjCounterCount); ?>">0</span>
                      <span><?php echo esc_html($tjCounterSuffix); ?></span>
                    </div>
                    <?php if (!empty($tjCounterTitle)): ?>
                      <span class="sub-title">
                        <?php echo tj_kses($tjCounterTitle, 'tjcore'); ?>
                      </span>
                    <?php endif; ?>
                  </div>
                <?php endforeach; ?>
              <?php endif; ?>

              <?php if (!empty($btn_link['url'])): ?>
                <div class="circle-wrap-item">
                  <div class="circle-wrap">
                    <?php if (!empty($tj_circle_image['url'])): ?>
                      <img class="rotate-image" src="<?php echo esc_url($tj_circle_image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_circle_image['id'], '_wp_attachment_image_alt', true)); ?>">
                    <?php endif; ?>
                    <a class="circle" href="<?php echo esc_url($btn_link['url']); ?>">
                      <i class="tji-arrow-right"></i>
                    </a>
                  </div>
                </div>
              <?php endif; ?>

            </div>
          <?php endif; ?>
        </div>
        <?php if (!empty($bannerImage['url'])): ?>
          <div <?php echo $this->get_render_attribute_string('tj_image_arg'); ?>>
            <img src="<?php echo esc_url($bannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($bannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />
          </div>
        <?php endif; ?>
        <?php if (!empty($tj_show_counter)): ?>
          <div class="hero-funfact d-lg-none wow fadeInUp" data-wow-delay="0.3s" <?php if (!empty($tj_counter_image['url'])) { ?> data-bg-image="<?php echo esc_url($tj_counter_image['url']); ?>" <?php } ?>>
            <?php if (count($counters) > 0): ?>
              <?php foreach ($counters as $item):
                $tjCounterCount = (!empty($item['tj_ff_number'])) ? $item['tj_ff_number'] : "";
                $tjCounterPrefix = (!empty($item['tj_ff_prefix'])) ? $item['tj_ff_prefix'] : "";
                $tjCounterSuffix = (!empty($item['tj_ff_suffix'])) ? $item['tj_ff_suffix'] : "";
                $tjCounterTitle = (!empty($item['tj_ff_title'])) ? $item['tj_ff_title'] : "";
              ?>
                <div class="counter-item">
                  <div class="number">
                    <span><?php echo esc_html($tjCounterPrefix); ?></span>
                    <span class="odometer" data-count="<?php echo esc_html($tjCounterCount); ?>">0</span>
                    <span><?php echo esc_html($tjCounterSuffix); ?></span>
                  </div>
                  <?php if (!empty($tjCounterTitle)): ?>
                    <span class="sub-title">
                      <?php echo tj_kses($tjCounterTitle, 'tjcore'); ?>
                    </span>
                  <?php endif; ?>
                </div>
              <?php endforeach; ?>
            <?php endif; ?>

            <?php if (!empty($btn_link['url'])): ?>
              <div class="circle-wrap-item">
                <div class="circle-wrap">
                  <?php if (!empty($tj_circle_image['url'])): ?>
                    <img class="rotate-image" src="<?php echo esc_url($tj_circle_image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_circle_image['id'], '_wp_attachment_image_alt', true)); ?>">
                  <?php endif; ?>
                  <a class="circle" href="<?php echo esc_url($btn_link['url']); ?>">
                    <i class="tji-arrow-right"></i>
                  </a>
                </div>
              </div>
            <?php endif; ?>

          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <?php if (!empty($bannerbgImage['url'])): ?>
    <div class="hero-three-bg el-bg-image" data-bg-image="<?php echo esc_url($bannerbgImage['url']); ?>"></div>
  <?php endif; ?>
  <?php if (!empty($tj_shape_image)): ?>
    <div class="hero-shape move-anim">
      <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shapes/h4-hero-shape-1.svg" alt="Shapes">
    </div>
  <?php endif; ?>
</section>








<!-- end: Banner -->