<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);

// include_posts
$post__in = '';
if (!empty($settings['post__in'])) {
  $post__not_in = $settings['post__in'];
  $args['post__in'] = $post__in;
}

// exclude_posts
$post__not_in = '';
if (!empty($settings['post__not_in'])) {
  $post__not_in = $settings['post__not_in'];
  $args['post__not_in'] = $post__not_in;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';
$ignore_sticky_posts = (!empty($settings['ignore_sticky_posts']) && 'yes' == $settings['ignore_sticky_posts']) ? true : false;

// offset
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// Posts Include array
$pI_ids = [];
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// Posts Exclude array
$pE_ids = [];
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

// args
$args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
  'ignore_sticky_posts' => $ignore_sticky_posts
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'category',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'category',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'category',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}

// The Query
$query = new \WP_Query($args);

if (! $query->found_posts) {
  return;
}

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$wrapClass = "tj__slider-wrapper tj_blog_carousel_wrap";
if (!empty($tjAnimation)) {
  $wrapClass .= " wow $tjAnimationName";
  $this->add_render_attribute('wrapper', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}

//slider settings
$show_dots   = (in_array($settings['navigation'], ['dots', 'both']));
$show_arrows = (in_array($settings['navigation'], ['arrows', 'both']));


$slider_settings = [
  'loop'           => $settings['loop'],
  'speed'          => $settings['speed'],
  'allowTouchMove' => $settings['allow_touch_move'],
  'slidesPerView'  => $settings['slides_to_show'],
  'spaceBetween'   => $settings['space_between'],
  // 'centeredSlides' => true,
];

if ('yes' === $settings['autoplay']) {
  $slider_settings['autoplay'] = [
    'delay'                => $settings['autoplay_delay'],
    'disableOnInteraction' => $settings['autoplay_interaction'],
  ];
}

if ($show_arrows) {
  $slider_settings['navigation'] = [
    'nextEl' => '.elementor-element-' . $this->get_id() . ' .tj_slider_next',
    'prevEl' => '.elementor-element-' . $this->get_id() . ' .tj_slider_prev',
  ];
}

if ($show_dots) {
  $slider_settings['pagination'] = [
    'el'        => '.elementor-element-' . $this->get_id() . ' .tj_slider_pagination',
    'clickable' => true,
  ];
}

//slider breakpoints
$active_breakpoints = Elementor\Plugin::$instance->breakpoints->get_active_breakpoints();

foreach ($active_breakpoints as $breakpoint_name => $breakpoint) {
  $slides_to_show = ! empty($settings['slides_to_show_' . $breakpoint_name]) ? $settings['slides_to_show_' . $breakpoint_name] : $settings['slides_to_show'];

  $slider_settings['breakpoints'][$breakpoint->get_value()]['slidesPerView'] = $slides_to_show;
}

// wrapper class
$this->add_render_attribute(
  'wrapper',
  [
    'class'         => $wrapClass,
    'data-settings' => json_encode($slider_settings), //phpcs:ignore
  ]
);

// carousel class
$this->add_render_attribute(
  'carousel-wrapper',
  [
    'class' => 'tj__slider blog_carousel_wrap swiper swiper-container',
    'id'   => 'blogCarousel-' . $this->get_id(),
    'dir'   => $settings['direction'],
    'style' => 'position: static',
  ]
);
?>

<div <?php $this->print_render_attribute_string('wrapper'); ?>>
  <?php if ($query->have_posts()) : ?>

    <div <?php $this->print_render_attribute_string('carousel-wrapper'); ?>>
      <div class="swiper-wrapper">
        <?php while ($query->have_posts()) :  $query->the_post();

          $categories = get_the_terms(get_the_ID(), 'category');
        ?>
          <div class="blog-style-2 blog-el-item swiper-slide">
            <div class="blog-images">
              <?php if (has_post_thumbnail()) : ?>
                <a href="<?php the_permalink(get_the_ID()); ?>">
                  <?php the_post_thumbnail('full'); ?>
                </a>
              <?php endif; ?>
              <?php if ("yes" == $settings['tj_post_date']) : ?>
                <div class="blog-date">
                  <span class="date"><?php the_time('d', get_the_ID()); ?></span>
                  <span class="month"><?php the_time('M', get_the_ID()); ?></span>
                </div>
              <?php endif; ?>
            </div>
            <div class="blog-content">
              <div class="blog-two-meta blog-el-meta">
                <ul>
                  <?php if ("yes" == $settings['tj_post_category'] && (!empty($categories))):

                    $max = !empty($settings['tj_max_category']) ? intval($settings['tj_max_category']) : 1;

                    // Slice category array to limit output
                    $limited_categories = array_slice($categories, 0, $max);
                    foreach ($limited_categories as $cat): ?>
                      <li>
                        <a class="meta-link blog-el-category" href="<?php echo esc_url(get_category_link($cat->term_id)); ?>">
                          <?php echo esc_html($cat->name); ?>
                        </a>
                      </li>
                  <?php endforeach;
                  endif; ?>
                  <?php if ("yes" == $settings['tj_post_comment']) : ?>
                    <li class="blog-el-comment"><?php comments_number(); ?></li>
                  <?php endif; ?>
                </ul>
              </div>
              <h4 class="title blog-el-title under-line">
                <a href="<?php the_permalink(get_the_ID()); ?>">
                  <?php echo wp_trim_words(get_the_title(get_the_ID()), $settings['tj_post_title_word'], '...'); ?>
                </a>
              </h4>
              <?php if (!empty($settings['tj_post_content'])) :
                $tj_post_content_limit = (!empty($settings['tj_post_content_limit'])) ? $settings['tj_post_content_limit'] : '';
              ?>
                <div class="desc"><?php echo wp_trim_words(get_the_content(get_the_ID()), $tj_post_content_limit, '...'); ?></div>
              <?php endif; ?>

              <?php if (!empty($settings['tj_btn'])) : ?>
                <div class="blog-button">
                  <a class="blog-btn text-btn" href="<?php the_permalink(get_the_ID()); ?>">
                    <?php echo esc_html__($settings['tj_btn'], 'tjcore'); ?>
                    <?php tj_render_icon($settings, 'post_button_icon', 'tj_post_button_icon') ?>
                  </a>
                </div>
              <?php endif; ?>
            </div>
          </div>
        <?php endwhile;
        wp_reset_query(); ?>
      </div>

      <?php if ($show_arrows) : ?>
        <button class="tj_slider_prev tj_slider_nav slider-prev">
          <?php tj_render_icon($settings, "previous_icon", "navigation_previous_icon"); ?>
        </button>

        <button class="tj_slider_next tj_slider_nav slider-next">
          <?php tj_render_icon($settings, "next_icon", "navigation_next_icon"); ?>
        </button>
      <?php endif; ?>

      <?php if ($show_dots) : ?>
        <div class="tj_slider_pagination swiper_pagination el-dots"></div>
      <?php endif; ?>
    </div>

  <?php else :
    printf("%s", esc_html__('No posts available!', 'tjcore'));
  endif; ?>
</div>