<?php
$brands   = (!empty($settings['brands_items'])) ? $settings['brands_items'] : "";

$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $brandsClass = "tj-brand-slider carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj-brands-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $brandsClass = "tj-brand-slider carouselWrap";
}
$this->add_render_attribute('tj-brands-arg', 'class', $brandsClass);

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

?>

<?php if (!empty($brands)): ?>
  <div <?php echo $this->get_render_attribute_string('tj-brands-arg'); ?> data-loop="<?php echo $loop; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
    <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper brand-slider-2 swiper-container" id="brandsCarousel-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper brand_wrapper">
        <?php foreach ($brands as $brand):

          $link = !empty($brand['brand_link']['url']) ? $brand['brand_link']['url'] : '';
          $target = !empty($brand['brand_link']['is_external']) ? '_blank' : '';
          $rel = !empty($brand['brand_link']['nofollow']) ? 'nofollow' : '';
          $image = $brand['brand_image'];

        ?>
          <div class="swiper-slide">
            <?php
            if (!empty($link)) :
              $href = 'href="' . esc_attr($link) . '"';
              $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
              $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
            ?>
              <div class="brand-logo">
                <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                  <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>" />
                </a>
              </div>
            <?php else: ?>
              <div class="brand-logo">
                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>" />
              </div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
<?php endif; ?>