<?php
$brands   = (!empty($settings['brands_items'])) ? $settings['brands_items'] : "";

$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$brandsClass = "h9-brands overflow-hidden";
if (!empty($tjAnimation)) {
  $brandsClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-brands-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-brands-arg', 'class', $brandsClass);
?>
<div <?php $this->print_render_attribute_string('tj-brands-arg'); ?>>
  <?php if (!empty($brands)): ?>

    <?php foreach ($brands as $brand):

      $link = !empty($brand['brand_link']['url']) ? $brand['brand_link']['url'] : '';
      $target = !empty($brand['brand_link']['is_external']) ? '_blank' : '';
      $rel = !empty($brand['brand_link']['nofollow']) ? 'nofollow' : '';
      $image = $brand['brand_image'];

      if (!empty($link)) :
        $href = 'href="' . esc_attr($link) . '"';
        $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
        $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
    ?>
        <div class="brand_item">
          <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
            <div>
              <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>" />
              <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          </a>
        </div>
      <?php else: ?>
        <div class="brand_item">
          <div>
            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>" />
            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>" />
          </div>
        </div>
  <?php endif;
    endforeach;
  endif; ?>
</div>