<?php

$tj_contact_list = !empty($settings['tj_contact_list']) ? $settings['tj_contact_list'] : "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
    $formClass = "contact-item style-2 wow $tjAnimationName";
    $this->add_render_attribute('tj-form-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
    $formClass = "contact-item style-2";
}
$this->add_render_attribute('tj-form-arg', 'class', $formClass);

?>

<div <?php echo $this->get_render_attribute_string('tj-form-arg'); ?>>
    <?php if (!empty($settings['tj_info_icon']['value'])) : ?>
        <div class="contact-icon">
            <?php tj_render_icon($settings, 'tj_info_icon', 'info_icon'); ?>
        </div>
    <?php endif; ?>
    <?php if (!empty($settings['tj_title'])) : ?>
        <h3 class="contact-title"><?php echo esc_html($settings['tj_title']); ?></h3>
    <?php endif; ?>
    <ul class="contact-list">
        <?php foreach ($tj_contact_list as $info):
            $infoTitle = !empty($info['tj_info_title']) ? $info['tj_info_title'] : "";
            $link = !empty($info['tj_info_link']['url']) ? $info['tj_info_link']['url'] : '';
            $tj_active   = !empty($info['tj_active']) ? 'active' : '';

        ?>
            <li class="<?php echo esc_attr($tj_active); ?>">
                <?php if (!empty($infoSubtitle)) : ?>
                    <?php echo esc_html($infoSubtitle); ?>
                <?php endif; ?>
                <?php if (!empty($infoTitle)): ?>
                    <?php
                    if (!empty($link)) :
                        $href = 'href="' . esc_attr($link) . '"';
                    ?>
                        <a <?php echo $href; ?>>
                            <?php echo esc_html($infoTitle); ?>
                        </a>
                    <?php else: ?>
                        <p><?php echo esc_html($infoTitle); ?></p>
                    <?php endif; ?>
                <?php endif; ?>
            </li>
        <?php endforeach; ?>
    </ul>
</div>