<?php

$counters = !empty($settings['tj_counter_list']) ? $settings['tj_counter_list'] : [];

// animation
$tjAnimation = $settings['tj_animation'] ?? '';
$tjAnimationName = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

$counterClass = "counter-wrapper";
if (!empty($tjAnimation)) {
  $counterClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-counter-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-counter-arg', 'class', $counterClass);
?>

<?php if (count($counters) > 0): ?>

  <div <?php echo $this->get_render_attribute_string('tj-counter-arg'); ?>>
    <?php foreach ($counters as $item):
      $tjCounterCount = (!empty($item['tj_ff_number'])) ? $item['tj_ff_number'] : "";
      $tjCounterPrefix = (!empty($item['tj_ff_prefix'])) ? $item['tj_ff_prefix'] : "";
      $tjCounterSuffix = (!empty($item['tj_ff_suffix'])) ? $item['tj_ff_suffix'] : "";
      $tjCounterTitle = (!empty($item['tj_ff_title'])) ? $item['tj_ff_title'] : "";
    ?>
      <div class="counter-item">
        <div class="bottom-line d-md-none"></div>
        <div class="number">
          <span><?php echo tj_kses($tjCounterPrefix); ?></span>
          <span class="odometer" data-count="<?php echo tj_kses($tjCounterCount); ?>">0</span>
          <span><?php echo tj_kses($tjCounterSuffix); ?></span>
        </div>
        <?php if (!empty($tjCounterTitle)): ?>
          <span class="sub-title">
            <?php echo tj_kses($tjCounterTitle, 'tjcore'); ?>
          </span>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>