<?php
$counters = !empty($settings['tj_counter_list_2']) ? $settings['tj_counter_list_2'] : [];

// animation
$tjAnimation = $settings['tj_animation'] ?? '';
$tjAnimationName = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

$counterClass = "h6-about-funfact";
if (!empty($tjAnimation)) {
  $counterClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-counter-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-counter-arg', 'class', $counterClass);
?>

<?php if (count($counters) > 0): ?>
  <div <?php echo $this->get_render_attribute_string('tj-counter-arg'); ?>>

    <?php foreach ($counters as $item):
      $tjCounterCount = (!empty($item['tj_ff_number_2'])) ? $item['tj_ff_number_2'] : "";
      $tjCounterPrefix = (!empty($item['tj_ff_prefix_2'])) ? $item['tj_ff_prefix_2'] : "";
      $tjCounterSuffix = (!empty($item['tj_ff_suffix_2'])) ? $item['tj_ff_suffix_2'] : "";
      $tjCounterTitle = (!empty($item['tj_ff_title_2'])) ? $item['tj_ff_title_2'] : "";
      $tjCounterDesc = (!empty($item['tj_ff_desc_2'])) ? $item['tj_ff_desc_2'] : "";
    ?>
      <div class="h6-about-funfact-item">
        <div class="counter-item">
          <div class="number">
            <span><?php echo tj_kses($tjCounterPrefix); ?></span>
            <span class="odometer" data-count="<?php echo esc_html($tjCounterCount); ?>"><?php esc_html_e('0', 'tjcore'); ?></span>
            <span><?php echo tj_kses($tjCounterSuffix); ?></span>
          </div>

          <?php if (!empty($tjCounterTitle)): ?>
            <span class="sub-title">
              <?php echo tj_kses($tjCounterTitle, 'tjcore'); ?>
            </span>
          <?php endif; ?>

        </div>
        <?php if (!empty($tjCounterDesc)): ?>
          <div class="desc">
            <?php echo tj_kses($tjCounterDesc); ?>
          </div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>

  </div>
<?php endif; ?>