<?php
$ctaTitle = ($settings['tj_title']) ?? "";
$ctaTitleTag = $settings['tj_title_tag'] ?? "h2";

$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';

if ($tj_gsap_animation) {
  $titleClass = "title text-anim";
} else {
  $titleClass = "title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

$tjFormStyle   = $settings['form_style'] ?? "";
$tjSelectForm   = $settings['tj_select_form'] ?? "";
$tjShortcode   = $settings['tj_shortcode'] ?? "";

$tjAnimation      = $settings['tj_animation'];
$tjAnimationName  = $settings['tj_animation_name'];
$tjAnimationDelay = $settings['tj_animation_delay'];

if (!empty($tjAnimation)) {
  $wrapClass = "newsletter-form style-4 wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $wrapClass = "newsletter-form style-4";
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrapClass);

?>


<section class="h4-cta-section el-section">
  <?php if (!empty($settings['tj_bgimage']['url'])): ?>
    <div class="thumb">
      <img src="<?php echo esc_url($settings['tj_bgimage']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_bgimage']['id'], '_wp_attachment_image_alt', true)); ?>">
    </div>
  <?php endif; ?>
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="h4-cta-wrapper">
          <?php if (!empty($settings['tj_bgshape']['url'])): ?>
            <div class="h4-cta-shape">
              <img src="<?php echo esc_url($settings['tj_bgshape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_bgshape']['id'], '_wp_attachment_image_alt', true)); ?>">
            </div>
          <?php endif; ?>
          <div class="h4-cta-newsletter tj-newsletter">
            <?php if (!empty($ctaTitle)): ?>
              <?php printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($ctaTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($ctaTitle)
              ); ?>
            <?php endif; ?>
            <?php if (!empty($tjShortcode) || !empty($tjSelectForm)): ?>
              <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
                <div class="form-input">
                  <?php if ("shortcode" == $tjFormStyle):
                    echo do_shortcode($tjShortcode);
                  else:
                    if (!empty($tjSelectForm)) :
                      echo do_shortcode('[contact-form-7  id="' . $tjSelectForm . '"]');
                    else :
                      printf("%s", esc_html_e("Select Contact Form", 'tjcore'));
                    endif;
                  endif; ?>
                </div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>