<?php
$ctaTitle = ($settings['tj_title']) ?? "";
$ctaTitleTag = $settings['tj_title_tag'] ?? "h2";

$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif ($tj_gsap_animation) {
  $titleClass = "title tj-el-title text-anim";
} else {
  $titleClass = "title tj-el-title";
}

$this->add_render_attribute('title_args', 'class', $titleClass);

// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnText = $settings['tj_btn_text'] ?? '';

$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay']['size'] ?? '';

// button
$btnClass = "tj-primary-btn white-btn";
if (!empty($tjButtonAnimation)) {
  $btnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', "{$tjButtonAnimationDelay}s");
}
$this->add_render_attribute('tj_button_arg', 'class', $btnClass);

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
?>

<!-- start: Cta Section -->
<section class="tj-cta-section tj-el-section">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="cta-wrapper tj-wrapper">
          <div class="cta-title">
            <?php if (!empty($ctaTitle)): ?>
              <?php printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($ctaTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($ctaTitle)
              ); ?>
            <?php endif; ?>
          </div>
          <?php if ($tjButtonShow === 'yes'): ?>
            <div class="cta-button">
              <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                <span class="btn_inner">
                  <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                    <span class="btn_icon">
                      <span>
                        <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                        <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                      </span>
                    </span>
                  <?php endif; ?>
                  <span class="btn_text">
                    <span>
                      <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
                    </span>
                  </span>
                </span>
              </a>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <?php if (!empty($settings['tj_image']['url'])): ?>
    <img class="cta-shape-1" <?php echo $this->get_render_attribute_string('tj-image-arg'); ?> src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
  <?php endif; ?>
  <?php if (!empty($settings['tj_image_2']['url'])): ?>
    <img class="cta-shape-2" <?php echo $this->get_render_attribute_string('tj-image-arg'); ?> src="<?php echo esc_url($settings['tj_image_2']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_2']['id'], '_wp_attachment_image_alt', true)); ?>">
  <?php endif; ?>
</section>
<!-- end: Cta Section -->