<?php
$ctaTitle = ($settings['tj_title']) ?? "";
$ctaTitleTag = $settings['tj_title_tag'] ?? "h2";

$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "sec-title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif ($tj_gsap_animation) {
  $titleClass = "sec-title tj-el-title text-anim";
} else {
  $titleClass = "sec-title tj-el-title";
}

$this->add_render_attribute('title_args', 'class', $titleClass);

// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnText = $settings['tj_btn_text'] ?? '';

$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay']['size'] ?? '';

// button
$btnClass = "tj-primary-btn";
if (!empty($tjButtonAnimation)) {
  $btnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', "{$tjButtonAnimationDelay}s");
}
$this->add_render_attribute('tj_button_arg', 'class', $btnClass);

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}

// button 2
$tjButton2Show = !empty($settings['tj_button2_show']) ? $settings['tj_button2_show'] : 'no';
$tjBtn2Icon = $settings['tj_btn2_icon'] ?? '';
$tjBtn2Text = $settings['tj_btn2_text'] ?? '';

$tjBtn2LinkType = $settings['tj_btn2_link_type'] ?? '';
$tjBtn2Link = $settings['tj_btn2_link'] ?? '';
$tjBtn2PageLink = $settings['tj_btn2_page_link'] ?? '';
$tjButton2Animation   = $settings['tj_button2_animation'] ?? '';
$tjButton2AnimationName   = $settings['tj_button2_animation_name'] ?? '';
$tjButton2AnimationDelay   = $settings['tj_button2_animation_delay']['size'] ?? '';

// button2
$btnClass2 = "tj-primary-btn";
if (!empty($tjButton2Animation)) {
  $btnClass2 .= " wow $tjButton2AnimationName";
  $this->add_render_attribute('tj_button_arg2', 'data-wow-delay', "{$tjButton2AnimationDelay}s");
}
$this->add_render_attribute('tj_button_arg2', 'class', $btnClass2);

if ('2' == $tjBtn2LinkType) {
  $this->add_render_attribute('tj_button_arg2', 'href', get_permalink($tjBtn2PageLink));
  $this->add_render_attribute('tj_button_arg2', 'target', '_self');
  $this->add_render_attribute('tj_button_arg2', 'rel', 'nofollow');
} else {
  if (!empty($tjBtn2Link['url'])) {
    $this->add_link_attributes('tj_button_arg2', $tjBtn2Link);
  }
}


?>

<!-- start: Cta Section -->
<section class="h5-cta-section tj-el-section">
  <?php if (!empty($settings['tj_image']['url'])): ?>
    <div class="thumb">
      <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
    </div>
  <?php endif; ?>
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="h5-cta-wrapper tj-wrapper">
          <?php if (!empty($ctaTitle)): ?>
            <?php printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($ctaTitleTag),
              $this->get_render_attribute_string('title_args'),
              tj_kses($ctaTitle)
            ); ?>
          <?php endif; ?>

          <div class="h5-cta-contact">
            <?php if ($tjButtonShow === 'yes'): ?>
              <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                <span class="btn_inner">
                  <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                    <span class="btn_icon">
                      <span>
                        <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                        <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                      </span>
                    </span>
                  <?php endif; ?>
                  <span class="btn_text">
                    <span>
                      <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
                    </span>
                  </span>
                </span>
              </a>
            <?php endif; ?>
            <?php if ($tjButton2Show === 'yes'): ?>
              <a <?php echo $this->get_render_attribute_string('tj_button_arg2'); ?>>
                <span class="btn_inner">
                  <?php if (!empty($settings['tj_btn2_icon']['value'])) : ?>
                    <span class="btn_icon">
                      <span>
                        <?php tj_render_icon($settings, 'tj_btn2_icon', 'btn2_icon'); ?>
                        <?php tj_render_icon($settings, 'tj_btn2_icon', 'btn2_icon'); ?>
                      </span>
                    </span>
                  <?php endif; ?>
                  <span class="btn_text">
                    <span>
                      <?php echo esc_html__($tjBtn2Text, 'tjcore'); ?>
                    </span>
                  </span>
                </span>
              </a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>





<!-- end: Cta Section -->