<?php

$title = $settings['tj_feature_title'] ?? '';
$link = !empty($settings['tj_title_link']['url']) ? 'href=' . $settings['tj_title_link']['url'] : '';
$target = !empty($settings['tj_title_link']['is_external']) ? 'target=_blank' : '';
$rel = !empty($settings['tj_title_link']['nofollow']) ? 'rel=nofollow' : '';
$desc = $settings['tj_feature_desc'] ?? '';
$title_tag = $settings['tj_feature_title_tag'] ?? 'h5';


// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

$wrapClass = "h7-feature-item feature-el-item";
if (!empty($tjAnimation)) {
  $wrapClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrapClass);

?>

<div <?php $this->print_render_attribute_string('tj_wrap_arg'); ?>>
  <!-- icon -->
  <?php if (!empty($settings['tj_feature_icon']['value']) || !empty($settings['tj_image_icon']['url']) || !empty($settings['tj_svg_icon'])) : ?>
    <?php if ($settings['tj_icon_type'] == 'font') { ?>
      <div class="feature-icon el-icon">
        <?php tj_render_icon($settings, 'feature_icon', 'tj_feature_icon'); ?>
      </div>
    <?php } ?>
    <?php if ($settings['tj_icon_type'] == 'image') { ?>
      <div class="feature-icon el-icon">
        <img src="<?php echo esc_url($settings['tj_image_icon']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_icon']['id'], '_wp_attachment_image_alt', true)); ?>" />
      </div>
    <?php } ?>
    <?php if ($settings['tj_icon_type'] == 'svg') { ?>
      <div class="feature-icon el-icon svg-animate">
        <?php echo $settings['tj_svg_icon']; ?>
      </div>
    <?php } ?>
  <?php endif; ?>

  <div class="feature-content">
    <?php if (!empty($title)): ?>
      <<?php echo tag_escape($title_tag); ?> class="title el-title">
        <?php if (!empty($link)): ?>
          <a <?php echo esc_attr($link); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
            <?php echo tj_kses($title); ?>
          </a>
        <?php else: ?>
          <?php echo tj_kses($title); ?>
        <?php endif; ?>
      </<?php echo tag_escape($title_tag); ?>>
    <?php endif; ?>

    <?php if (!empty($desc)): ?>
      <div class="desc">
        <?php echo tj_kses($desc); ?>
      </div>
    <?php endif; ?>
  </div>
</div>