<?php
$copyrightText = $settings['tj_copyright_text'] ?? "";

$showFooterNavigation   = $settings['show_footer_navigation'] ?? "";
$tjFooterNavigation   = $settings['tj_navigation'] ?? "";
$showFooterSocials = $settings['is_footer_socials'] ?? "";
$flex_center = !empty($showFooterNavigation || $showFooterSocials) ? 'justify-content-center justify-content-lg-between' : 'justify-content-center';
$footerSocialsTitle = $settings['footer_socials_title'] ?? "";
$footerSocialsList = $settings['footer_socials_list'] ?? "";


?>

<div class="copyright-content-area <?php echo esc_attr($flex_center); ?>">
  <?php if (!empty($copyrightText)): ?>
    <!-- copyright text -->
    <div class="copyright-text">
      <?php echo tj_kses($copyrightText); ?>
    </div>
  <?php endif; ?>


  <?php if (!empty($showFooterSocials)): ?>
    <!-- socials -->
    <div class="copyright-socails">
      <?php if (!empty($footerSocialsList)): ?>
        <ul>
          <?php foreach ($footerSocialsList as $social):

            $link = !empty($social['footer_social_link']['url']) ? $social['footer_social_link']['url'] : '';
            $target = !empty($social['footer_social_link']['is_external']) ? '_blank' : '';
            $rel = !empty($social['footer_social_link']['nofollow']) ? 'nofollow' : '';
          ?>
            <li>
              <?php if (!empty($link)) :
                $href = 'href=' . $link . '';
                if (!empty($target)) :
                  $target = 'target=' . $target . '';
                endif;
                if (!empty($rel)) :
                  $rel = 'rel=' . $rel . '';
                endif;
              ?>
                <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                  <?php tj_render_icon($social, 'footer_social_icon', 'tj_footer_social_icon'); ?>
                </a>
              <?php else :
                tj_render_icon($social, 'footer_social_icon', 'tj_footer_social_icon');
              endif;
              ?>
            </li>
          <?php endforeach; ?>

        </ul>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <?php if ("yes" == $showFooterNavigation): ?>
    <div class="copyright-menu">
      <?php wp_nav_menu([
        'menu' => ($tjFooterNavigation && wp_get_nav_menu_object($tjFooterNavigation)) ? $tjFooterNavigation : 'footer-menu'
      ]); ?>
    </div>
  <?php endif; ?>
</div>