<?php
$footerLogo = $settings['tj_logo'] ?? "";
$footerDesc = $settings['tj_desc'] ?? "";
$socialTitle = $settings['tj_social_title'] ?? "";
$footerSocials = $settings['tj_social_list'] ?? "";
?>

<div class="footer-widget mb-0">
  <?php if (!empty($footerLogo['url'])): ?>
    <!-- footer logo -->
    <div class="footer-logo">
      <a href="<?php echo esc_url(home_url('/')); ?>" class="logo">
        <img src="<?php echo esc_url($footerLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($footerLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
      </a>
    </div>
  <?php endif; ?>

  <?php if (!empty($footerDesc)): ?>
    <div class="desc">
      <?php echo tj_kses($footerDesc); ?>
    </div>
  <?php endif; ?>
  <?php if (!empty($footerSocials)): ?>
    <div class="footer-social">
      <?php if (!empty($socialTitle)): ?>
        <h5 class="title"><?php echo tj_kses($socialTitle); ?></h5>
      <?php endif; ?>
      <ul>
        <?php foreach ($footerSocials as $social):

          $link = !empty($social['tj_social_link']['url']) ? $social['tj_social_link']['url'] : '';
          $target = !empty($social['tj_social_link']['is_external']) ? '_blank' : '';
          $rel = !empty($social['tj_social_link']['nofollow']) ? 'nofollow' : '';
        ?>
          <li>
            <?php if (!empty($link)) :
              $href = 'href=' . $link . '';
              if (!empty($target)) :
                $target = 'target=' . $target . '';
              endif;
              if (!empty($rel)) :
                $rel = 'rel=' . $rel . '';
              endif; ?>
              <a class="link" <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                <?php tj_render_icon($social, "social_icon", "tj_social_icon"); ?>
              </a>
            <?php else: ?>
              <?php tj_render_icon($social, "social_icon", "tj_social_icon"); ?>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>
</div>