<?php
$lists = !empty($settings['tj_menu_list']) ? $settings['tj_menu_list'] : [];
$tj_menu_title = $settings['tj_menu_title'] ?? "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
    $listClass = "tj-cta-list menu-widget wow $tjAnimationName";
    $this->add_render_attribute('tj_list_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
    $listClass = "tj-cta-list menu-widget";
}
$this->add_render_attribute('tj_list_arg', 'class', $listClass);
?>

<?php if (count($lists) > 0): ?>
    <ul <?php echo $this->get_render_attribute_string('tj_list_arg'); ?>>
        <?php foreach ($lists as $index => $item):
            $icon = !empty($item['tj_menu_icon']) ? $item['tj_menu_icon'] : '';
            $menuItem = !empty($item['tj_menu_item']) ? $item['tj_menu_item'] : '';

            $tj_menu_link_type   =  $item['tj_menu_link_type'] ?? "";
            $tj_menu_link   =  $item['tj_menu_link'] ?? "";
            $tj_menu_page_link   = $item['tj_menu_page_link'] ?? "";
            $link_key = 'tj_menu_arg_' . $index;
            if ('2' == $tj_menu_link_type) {
                $this->add_render_attribute($link_key, 'href', get_permalink($tj_menu_page_link));
                $this->add_render_attribute($link_key, 'target', '_self');
            } else {
                if (!empty($tj_menu_link['url'])) {
                    $this->add_link_attributes($link_key, $tj_menu_link);
                }
            }
        ?>
            <li>
                <a <?php echo $this->get_render_attribute_string($link_key); ?>>
                    <?php if (!empty($icon['value'])) : ?>
                        <?php tj_render_icon($item, 'menu_icon', 'tj_menu_icon') ?>
                    <?php endif; ?>
                    <?php echo tj_kses($menuItem, 'tjcore');  ?>
                </a>

            </li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>