<?php
$tjSelectForm   = $settings['tj_select_form'] ?? "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $formClass = "contact-form-one tj-form wow $tjAnimationName";
  $this->add_render_attribute('tj-form-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $formClass = "contact-form-one tj-form";
}
$this->add_render_attribute('tj-form-arg', 'class', $formClass);


$lists = !empty($settings['tj_contact_list']) ? $settings['tj_contact_list'] : [];
$tj_title = $settings['tj_title'] ?? "";
$tj_hide_contact = $settings['tj_hide_contact'];

?>

<div <?php echo $this->get_render_attribute_string('tj-form-arg'); ?>>
  <?php if (!empty($tj_title)): ?>
    <h3 class="title"><?php echo esc_html($tj_title); ?></h3>
  <?php endif; ?>
  <?php if (!empty($tj_hide_contact)): ?>
    <div class="contact-item">
      <?php foreach ($lists as $index => $item):
        $icon = !empty($item['tj_contact_icon']) ? $item['tj_contact_icon'] : '';
        $title = !empty($item['tj_contact_title']) ? $item['tj_contact_title'] : '';
        $tj_contact_link   =  $item['tj_contact_link'] ?? "";

        if (!empty($tj_contact_link['url'])) {
          $link_key = 'tj_link_arg_' . $index;
          $this->add_link_attributes($link_key, $tj_contact_link);
        }

      ?>
        <div class="contact-text">
          <?php if (!empty($icon['value'])) : ?>
            <?php tj_render_icon($item, 'menu_icon', 'tj_contact_icon') ?>
          <?php endif; ?>
          <?php if (!empty($tj_contact_link['url'])) : ?>
            <a <?php echo $this->get_render_attribute_string($link_key); ?>>
              <?php echo esc_html($title); ?>
            </a>
          <?php else: ?>
            <?php echo esc_html($title); ?>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
  <div class="tj-form">
    <?php if (!empty($tjSelectForm)) : ?>
      <?php echo do_shortcode('[contact-form-7  id="' . $tjSelectForm . '"]'); ?>
    <?php
    else :
      printf("%s", esc_html_e("Select Contact Form", 'tjcore'));
    endif; ?>
  </div>
</div>