<?php
$isHeaderAbsolute = ("yes" == $settings['is_header_absolute']) ? "header-absolute" : "";
$isHeaderSticky = !empty($settings['header_sticky_direction'] && $settings['is_header_sticky']) ? $settings['header_sticky_direction'] : '';

// logo text
$has_text = ('yes' == $settings['show_text_logo']) ? "has-text" : "";
$logo_text = $settings['logo_text'] ?? "";

$tjHeaderLogo = $settings['tj_logo'] ?? "";
$tjHeaderNavigation   = $settings['tj_navigation'] ?? "";

// search
$showHeaderSearch   = $settings['show_header_search'] ?? "";
$tj_search_text   = $settings['tj_search_text'] ?? esc_html__("Explore", 'tjcore');
$tj_header_menu_text   = $settings['tj_header_menu_text'] ?? esc_html__("Menu", 'tjcore');

$show_header_sidebar   = $settings['show_header_sidebar'] ?? "";

// button
$showHeaderButton   = $settings['show_header_btn'] ?? "";
$tjBtnText   = $settings['tj_btn_text'] ?? esc_html__("Get in touch", 'tjcore');
$tjBtnLinkType   =  $settings['tj_btn_link_type'] ?? "";
$tjBtnLink   =  $settings['tj_btn_link'] ?? "";
$tjBtnPageLink   = $settings['tj_btn_page_link'] ?? "";

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_btn_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_btn_arg', 'target', '_self');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_btn_arg', $tjBtnLink);
  }
}
?>
<!-- start: Header Area -->
<header class="tj-header-area header-2 <?php printf("%s", esc_attr($isHeaderAbsolute)); ?>">
  <div class="header-bottom">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="header-wrapper">
            <?php if (!empty($tjHeaderLogo['url']) || !empty($logo_text)) : ?>
              <div class="site-logo <?php printf("%s", esc_attr($has_text)); ?>">
                <?php if (!empty($tjHeaderLogo['url'])) : ?>
                  <a class="primary_logo logo" href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?php echo esc_url($tjHeaderLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjHeaderLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
                  </a>
                <?php endif; ?>
                <?php if (!empty($logo_text)) : ?>
                  <h1 class="logo-text"><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo tj_kses($logo_text); ?></a></h1>
                <?php endif; ?>
              </div>
            <?php endif; ?>
            <!-- main navigation -->
            <div class="mainmenu d-lg-block d-none mainMenu" id="main-menu">
              <?php echo $this->render_tj_nav_menu($settings['tj_navigation'], true); ?>
            </div>
            <?php if (!empty("yes" == $showHeaderSearch || "yes" == $showHeaderButton) || "yes" == $show_header_sidebar) : ?>
              <div class="header_right_info d-none d-lg-inline-flex">

                <?php if ("yes" == $showHeaderButton) : ?>
                  <!-- contact -->
                  <a class="header_contact d-none d-xl-inline-flex" <?php echo $this->get_render_attribute_string('tj_btn_arg'); ?>>
                    <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                      <span class="icon"><?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?></span>
                    <?php endif; ?>
                    <span class="text"><?php echo esc_html($tjBtnText); ?></span>
                  </a>
                <?php endif; ?>
                <?php if (!empty($showHeaderSearch)) : ?>
                  <!-- search btn -->
                  <button class="header_search d-none d-lg-inline-flex">
                    <?php echo esc_html($tj_search_text); ?>
                    <?php tj_render_icon($settings, "search_icon", "tj_search_icon"); ?>
                  </button>
                <?php endif; ?>

                <?php if (!empty($show_header_sidebar)) : ?>
                  <!-- menu bar -->
                  <button class="menu_btn">
                    <?php echo esc_html($tj_header_menu_text); ?>
                    <?php if (!empty($settings['tj_menu_icon']['value'])) : ?>
                      <?php tj_render_icon($settings, 'tj_menu_icon', 'menu_icon'); ?>
                    <?php else : ?>
                      <span class="cubes">
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                      </span>
                    <?php endif; ?>
                  </button>
                <?php endif; ?>
              </div>
            <?php endif; ?>
            <!-- menu bar -->
            <button class="menu_btn d-lg-none hamburgerBtn">
              <?php echo esc_html($tj_header_menu_text); ?>
              <?php if (!empty($settings['tj_menu_icon']['value'])) : ?>
                <?php tj_render_icon($settings, 'tj_menu_icon', 'menu_icon'); ?>
              <?php else : ?>
                <span class="cubes">
                  <span></span>
                  <span></span>
                  <span></span>
                  <span></span>
                </span>
              <?php endif; ?>
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>

<header class="tj-header-area header-2 header-duplicate <?php printf("%s", esc_attr($isHeaderSticky)); ?>">
  <div class="header-bottom">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="header-wrapper">
            <?php if (!empty($tjHeaderLogo['url']) || !empty($logo_text)) : ?>
              <div class="site-logo <?php printf("%s", esc_attr($has_text)); ?>">
                <?php if (!empty($tjHeaderLogo['url'])) : ?>
                  <a class="primary_logo logo" href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?php echo esc_url($tjHeaderLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjHeaderLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
                  </a>
                <?php endif; ?>
                <?php if (!empty($logo_text)) : ?>
                  <h1 class="logo-text"><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo tj_kses($logo_text); ?></a></h1>
                <?php endif; ?>
              </div>
            <?php endif; ?>
            <!-- main navigation -->
            <div class="mainmenu d-lg-block d-none mainMenu">
              <?php echo $this->render_tj_nav_menu($settings['tj_navigation'], false); ?>
            </div>
            <?php if (!empty("yes" == $showHeaderSearch || "yes" == $showHeaderButton) || "yes" == $show_header_sidebar) : ?>
              <div class="header_right_info d-none d-lg-inline-flex">

                <?php if ("yes" == $showHeaderButton) : ?>
                  <!-- contact -->
                  <a class="header_contact d-none d-xl-inline-flex" <?php echo $this->get_render_attribute_string('tj_btn_arg'); ?>>
                    <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                      <span class="icon"><?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?></span>
                    <?php endif; ?>
                    <span class="text"><?php echo esc_html($tjBtnText); ?></span>
                  </a>
                <?php endif; ?>
                <?php if (!empty($showHeaderSearch)) : ?>
                  <!-- search btn -->
                  <button class="header_search d-none d-lg-inline-flex">
                    <?php echo esc_html($tj_search_text); ?>
                    <?php tj_render_icon($settings, "search_icon", "tj_search_icon"); ?>
                  </button>
                <?php endif; ?>

                <?php if (!empty($show_header_sidebar)) : ?>
                  <!-- menu bar -->
                  <button class="menu_btn">
                    <?php echo esc_html($tj_header_menu_text); ?>
                    <?php if (!empty($settings['tj_menu_icon']['value'])) : ?>
                      <?php tj_render_icon($settings, 'tj_menu_icon', 'menu_icon'); ?>
                    <?php else : ?>
                      <span class="cubes">
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                      </span>
                    <?php endif; ?>
                  </button>
                <?php endif; ?>
              </div>
            <?php endif; ?>
            <!-- menu bar -->
            <button class="menu_btn d-lg-none hamburgerBtn">
              <?php echo esc_html($tj_header_menu_text); ?>
              <?php if (!empty($settings['tj_menu_icon']['value'])) : ?>
                <?php tj_render_icon($settings, 'tj_menu_icon', 'menu_icon'); ?>
              <?php else : ?>
                <span class="cubes">
                  <span></span>
                  <span></span>
                  <span></span>
                  <span></span>
                </span>
              <?php endif; ?>
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>

<!-- end: Header Area -->

<?php if (!empty($showHeaderSearch)):
  $tjHeaderSearchTitle =  $settings['tj_header_search_text'] ?? "";
?>
  <!-- start: Search Popup -->
  <div class="search_popup" id="headerSearch-<?php echo $this->get_id(); ?>">
    <div class="search_close" id="searchClose-<?php echo $this->get_id(); ?>">
      <button type="button" class="search_close_btn">
        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M17 1L1 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
            stroke-linejoin="round" />
          <path d="M1 1L17 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
            stroke-linejoin="round" />
        </svg>
      </button>
    </div>
    <div class="container">
      <div class="row">
        <div class="col-xxl-12">
          <div class="tj_search_wrapper">
            <div class="search_form">
              <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
                <div class="search_input">
                  <?php if (!empty($tjHeaderSearchTitle)): ?>
                    <h4 class="title"><?php echo esc_html($tjHeaderSearchTitle); ?></h4>
                  <?php endif; ?>
                  <div class="search-box">
                    <input class="search-input-field" type="search" name="s" placeholder="<?php echo esc_attr__('Search here...', 'tjcore'); ?>" value="<?php echo esc_attr(get_search_query()); ?>" required>
                    <button type="submit">
                      <?php tj_render_icon($settings, "search_icon", "tj_search_icon"); ?>
                    </button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="search-popup-overlay" id="searchOverlay-<?php echo $this->get_id(); ?>"></div>
  <!-- end: Search Popup -->
<?php endif; ?>

<?php
$tjHeaderMobileLogo = $settings['tj_mobile_logo'] ?? "";
$showMobileSearch = $settings['show_mobile_search'] ?? "";
$mobileSearchPlaceholder = $settings['tj_mobile_search_placeholder'] ?? "";
$showMobileContact = $settings['is_mobile_contact'] ?? "";
$mobileContactTitle = $settings['mobile_contact_title'] ?? "";
$mobileContactList = $settings['mobile_contact_list'] ?? "";
$showMobileSocials = $settings['is_mobile_socials'] ?? "";
$mobileSocialsTitle = $settings['mobile_socials_title'] ?? "";
$mobileSocialsList = $settings['mobile_socials_list'] ?? "";
$mobileDesc = $settings['mobile_desc'] ?? "";
?>
<!-- start: Hamburger Menu -->
<div class="body-overlay" id="hamburgerOverlay-<?php echo $this->get_id(); ?>"></div>
<div class="hamburger-area" id="hamburger-<?php echo $this->get_id(); ?>" data-lenis-prevent>
  <div class="hamburger_bg"></div>
  <div class="hamburger_wrapper">

    <div class="hamburger_top d-flex align-items-center justify-content-between">

      <?php if (!empty($tjHeaderMobileLogo['url'])): ?>
        <!-- logo -->
        <div class="hamburger_logo">
          <a class="mobile_logo logo" href="<?php echo esc_url(home_url('/')); ?>">
            <img src="<?php echo esc_url($tjHeaderMobileLogo['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjHeaderMobileLogo['id'], '_wp_attachment_image_alt', true)); ?>" />
          </a>
        </div>
      <?php endif; ?>

      <!-- close -->
      <div class="hamburger_close" id="hamburgerClose-<?php echo $this->get_id(); ?>">
        <button class="hamburger_close_btn hamburgerCloseBtn"><?php tj_render_icon($settings, "mobile_close", "tj_mobile_close"); ?></button>
      </div>

    </div>

    <?php if (!empty($mobileDesc)): ?>
      <div class="hamburger-desc">
        <?php echo tj_kses($mobileDesc); ?>
      </div>
    <?php endif; ?>

    <?php if (!empty($showMobileSearch)): ?>
      <!-- search -->
      <div class="hamburger_search">
        <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
          <button type="submit"><?php tj_render_icon($settings, "mobile_search_icon", "tj_mobile_search_icon"); ?></button>
          <input type="search" autocomplete="off" name="s" value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php echo esc_attr__($mobileSearchPlaceholder, 'tjcore'); ?>" required />
        </form>
      </div>
    <?php endif; ?>

    <!-- mobile menu -->
    <div class="hamburger_menu">
      <div class="mobile_menu mobileMenu"></div>
    </div>

    <?php if (!empty($showMobileContact)): ?>
      <!-- contact -->
      <div class="hamburger-infos">
        <?php if (!empty($mobileContactTitle)): ?>
          <h4 class="hamburger-title"><?php echo esc_html($mobileContactTitle); ?></h4>
        <?php endif; ?>
        <div class="header-contact-info">
          <?php if (!empty($mobileContactList)):
            foreach ($mobileContactList as $contact):

              $link = !empty($contact['mobile_contact_link']['url']) ? $contact['mobile_contact_link']['url'] : '';
              $target = !empty($contact['mobile_contact_link']['is_external']) ? '_blank' : '';
              $rel = !empty($contact['mobile_contact_link']['nofollow']) ? 'nofollow' : '';
          ?>
              <div class="contact_item">
                <?php if (!empty($contact['mobile_contact_label'])): ?>
                  <span class="subtitle"><?php echo esc_html($contact['mobile_contact_label']); ?></span>
                <?php endif; ?>
                <div class="text">
                  <?php if (!empty($link)) :
                    $href = 'href=' . $link . '';
                    if (!empty($target)) :
                      $target = 'target=' . $target . '';
                    endif;
                    if (!empty($rel)) :
                      $rel = 'rel=' . $rel . '';
                    endif; ?>
                    <a class="link" <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                      <?php echo esc_html($contact['mobile_contact_text']); ?>
                    </a>
                  <?php else :
                    echo esc_html($contact['mobile_contact_text']);
                  endif; ?>
                </div>
              </div>
          <?php endforeach;
          endif; ?>
        </div>
      </div>
    <?php endif; ?>

    <?php if (!empty($showMobileSocials)): ?>
      <!-- socials -->
      <div class="hamburger-socials">
        <?php if (!empty($mobileSocialsTitle)): ?>
          <h4 class="hamburger-title"><?php echo esc_html($mobileSocialsTitle); ?></h4>
        <?php endif; ?>

        <?php if (!empty($mobileSocialsList)): ?>
          <ul>
            <?php foreach ($mobileSocialsList as $social):

              $link = !empty($social['mobile_social_link']['url']) ? $social['mobile_social_link']['url'] : '';
              $target = !empty($social['mobile_social_link']['is_external']) ? '_blank' : '';
              $rel = !empty($social['mobile_social_link']['nofollow']) ? 'nofollow' : '';
            ?>
              <li>
                <?php if (!empty($link)) :
                  $href = 'href=' . $link . '';
                  if (!empty($target)) :
                    $target = 'target=' . $target . '';
                  endif;
                  if (!empty($rel)) :
                    $rel = 'rel=' . $rel . '';
                  endif;
                ?>
                  <a <?php echo esc_attr($href); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                    <?php tj_render_icon($social, 'mobile_social_icon', 'tj_mobile_social_icon'); ?>
                  </a>
                <?php else :
                  tj_render_icon($social, 'mobile_social_icon', 'tj_mobile_social_icon');
                endif;
                ?>
              </li>
            <?php endforeach; ?>

          </ul>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
<!-- end: Hamburger Menu -->