<?php
$bannerContents = $settings['tj_banner_contents'] ?? [];
$shapeImage = $settings['tj_banner_shape_image'] ?? '';

$loop = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$slideNav = !empty($settings['slide_nav']) ? $settings['slide_nav'] : 'no';
$autoplay = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay = $settings['slide_autoplay_Delay'] ?? '5000';

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

?>

<section class="tj-hero-slider style-1 bannerWrap" data-loop="<?php echo $loop; ?>" data-nav="<?php echo $slideNav; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <?php if (!empty($bannerContents)): ?>
    <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper full-slider-active" id="bannerSlider-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($bannerContents as $key => $item) :
          $image = $item['tj_slider_image'] ?? "";
          $title = $item['tj_slider_title'] ?? "";
          $title_tag = $item['tj_title_tag'] ?? "h1";
          $subtitle = $item['tj_slider_subtitle'] ?? "";
          $showHighlighter = !empty($item['tj_show_awards']) ? $item['tj_show_awards'] : "no";
          $awardsImages = $item['tj_slider_awards_images'] ?? "";
          $text = $item['tj_slider_awards_text'] ?? "";

          $tjHeroButtonShow = !empty($item['tj_button_show']) ? $item['tj_button_show'] : 'no';
          $tjHeroBannerBtnText = $item['tj_hero_banner_btn_text'] ?? "";
          $tjHeroBannerBtnLinkType = $item['tj_hero_banner_btn_link_type'] ?? "";
          $tjHeroBannerBtnLink = $item['tj_hero_banner_btn_link'] ?? "";
          $tjHeroBannerBtnPageLink = $item['tj_hero_banner_btn_page_link'] ?? "";

          // btn link internal
          if ('2' == $tjHeroBannerBtnLinkType) {
            $link = get_permalink($tjHeroBannerBtnPageLink) ? 'href=' . get_permalink($tjHeroBannerBtnPageLink) : '';
            $target = 'target=_self';
            $rel = '';
          } else { // external
            $link = $tjHeroBannerBtnLink ? 'href=' . $tjHeroBannerBtnLink['url'] : '';
            $target = !empty($item['tj_hero_banner_btn_link']['is_external']) ? 'target=_blank' : '';
            $rel = !empty($item['tj_hero_banner_btn_link']['nofollow']) ? 'rel=nofollow' : '';
          }
        ?>
          <div class="swiper-slide">
            <section class="tj-slider-section" <?php if (!empty($image['url'])) { ?> data-bg-image="<?php echo esc_url($image['url']); ?>" <?php } ?>>
              <div class="container">
                <div class="row">
                  <div class="slider-wrapper">
                    <div class="slider-content style-1">
                      <!-- subtitle -->
                      <?php if (!empty($subtitle)): ?>
                        <span class="sub-title"><?php echo tj_kses($subtitle); ?></span>
                      <?php endif; ?>
                      <!-- title -->
                      <?php if (!empty($title)): ?>
                        <<?php echo esc_attr($title_tag); ?> class="slider-title"><?php echo tj_kses($title); ?></<?php echo esc_attr($title_tag); ?>>
                      <?php endif; ?>
                      <!-- button -->
                      <?php if ($tjHeroButtonShow === "yes"): ?>
                        <a class="tj-primary-btn slider-button" <?php echo esc_attr($link); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                          <span class="btn_inner">
                            <span class="btn_icon">
                              <span>
                                <?php tj_render_icon($item, 'btn_icon', 'tj_btn_icon'); ?>
                                <?php tj_render_icon($item, 'btn_icon', 'tj_btn_icon'); ?>
                              </span>
                            </span>

                            <?php if (!empty($tjHeroBannerBtnText)): ?>
                              <span class="btn_text">
                                <span><?php echo esc_html__($tjHeroBannerBtnText, 'tjcore'); ?></span>
                              </span>
                            <?php endif; ?>
                          </span>
                        </a>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
              <?php if ($showHighlighter === 'yes'): ?>
                <div class="slider-feature-wrap">
                  <div class="slider-feature-box">
                    <?php if (!empty($awardsImages['url'])): ?>
                      <div class="slider-logo">
                        <img src="<?php echo esc_url($awardsImages['url']); ?>" alt="<?php echo esc_attr(get_post_meta($awardsImages['id'], '_wp_attachment_image_alt', true)); ?>">
                      </div>
                    <?php endif; ?>

                    <?php if (!empty($text)): ?>
                      <div class="desc">
                        <p><?php echo tj_kses($text); ?></p>
                      </div>
                    <?php endif; ?>

                    <div class="slider-shape">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/slider-shapes.png" alt="Shapes">
                    </div>
                  </div>
                </div>
              <?php endif; ?>
            </section>
          </div>
        <?php
        endforeach;
        ?>
      </div>
      <?php if ($slideNav === 'yes'): ?>
        <div class="tj-navigation">
          <div class="tj-btn tj-btn-prev"><i class="tji-angle-left"></i></div>
          <div class="tj-sw-pagination"></div>
          <div class="tj-btn tj-btn-next"><i class="tji-angle-right"></i></div>
        </div>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</section>