<?php
$bannerContents = $settings['tj_slider2_content'] ?? [];
$shapeImage = $settings['tj_banner_shape_image'] ?? '';

$loop = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$slideNav = !empty($settings['slide_nav']) ? $settings['slide_nav'] : 'no';
$autoplay = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay = $settings['slide_autoplay_Delay'] ?? '5000';

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

?>

<section class="tj-hero-slider h7-hero-slider style-1 bannerWrap" data-loop="<?php echo $loop; ?>" data-nav="<?php echo $slideNav; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <?php if (!empty($bannerContents)): ?>
    <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper full-slider-active" id="bannerSlider-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($bannerContents as $key => $item) :
          $image = $item['tj_slider2_image'] ?? "";
          $subtitle = $item['tj_slider2_subtitle'] ?? "";
          $title = $item['tj_slider2_title'] ?? "";
          $title_tag = $item['tj_title_tag2'] ?? "h1";
          $description = $item['tj_slider2_desc'] ?? "";

          $tjHeroButtonShow = !empty($item['tj_button2_show']) ? $item['tj_button2_show'] : 'no';
          $tjHeroBannerBtnText = $item['tj_slider2_btn_text'] ?? "";
          $tjHeroBannerBtnLinkType = $item['tj_slider2_btn_link_type'] ?? "";
          $tjHeroBannerBtnLink = $item['tj_slider2_btn_link'] ?? "";
          $tjHeroBannerBtnPageLink = $item['tj_slider2_btn_page_link'] ?? "";

          // btn link internal
          if ('2' == $tjHeroBannerBtnLinkType) {
            $link = get_permalink($tjHeroBannerBtnPageLink) ? 'href=' . get_permalink($tjHeroBannerBtnPageLink) : '';
            $target = 'target=_self';
            $rel = '';
          } else { // external
            $link = $tjHeroBannerBtnLink ? 'href=' . $tjHeroBannerBtnLink['url'] : '';
            $target = !empty($item['tj_hero_banner_btn_link']['is_external']) ? 'target=_blank' : '';
            $rel = !empty($item['tj_hero_banner_btn_link']['nofollow']) ? 'rel=nofollow' : '';
          }

          $tjSliderContactBtnShow = !empty($item['tj_contact_btn_show']) ? $item['tj_contact_btn_show'] : 'no';
          $tjSliderContactBtnText = $item['tj_contact_btn_text'] ?? "";
          $tjSliderContactBtnLink = $item['tj_contact_btn_link'] ?? "";

          $contactLink = $tjSliderContactBtnLink ? 'href=' . $tjSliderContactBtnLink['url'] : '';
          $contactTarget = !empty($item['tj_contact_btn_link']['is_external']) ? 'target=_blank' : '';
          $contactRel = !empty($item['tj_contact_btn_link']['nofollow']) ? 'rel=nofollow' : '';
        ?>
          <div class="swiper-slide">
            <div class="tj-slider-section" <?php if (!empty($image['url'])) { ?> data-bg-image="<?php echo esc_url($image['url']); ?>" <?php } ?>>
              <div class="container">
                <div class="row">
                  <div class="slider-wrapper">
                    <div class="slider-content">
                      <?php if (!empty($subtitle)): ?>
                        <span class="sub-title">
                          <?php tj_render_icon($item, "subtitle_icon", "tj_slider2_subtitle_icon"); ?>
                          <?php echo esc_html__($subtitle); ?>
                        </span>
                      <?php endif; ?>

                      <?php if (!empty($title)): ?>
                        <<?php echo esc_attr($title_tag); ?> class="slider-title"><?php echo tj_kses($title); ?></<?php echo esc_attr($title_tag); ?>>
                      <?php endif; ?>

                      <?php if (!empty($description)): ?>
                        <div class="desc ">
                          <p><?php echo tj_kses($description); ?></p>
                        </div>
                      <?php endif; ?>

                      <div class="hero-action">

                        <?php if ($tjHeroButtonShow === "yes"): ?>
                          <!-- button -->
                          <a class="tj-primary-btn slider-button" <?php echo esc_attr($link); ?> <?php echo esc_attr($target); ?> <?php echo esc_attr($rel); ?>>
                            <span class="btn_inner">

                              <?php if (!empty($item['tj_slider2_btn_icon']['value'])): ?>
                                <span class="btn_icon">
                                  <span>
                                    <?php tj_render_icon($item, 'slider2_btn_icon', 'tj_slider2_btn_icon'); ?>
                                    <?php tj_render_icon($item, 'slider2_btn_icon', 'tj_slider2_btn_icon'); ?>
                                  </span>
                                </span>
                              <?php endif; ?>

                              <?php if (!empty($tjHeroBannerBtnText)): ?>
                                <span class="btn_text">
                                  <span><?php echo esc_html__($tjHeroBannerBtnText, 'tjcore'); ?></span>
                                </span>
                              <?php endif; ?>
                            </span>
                          </a>
                        <?php endif; ?>

                        <?php if ($tjSliderContactBtnShow === "yes"): ?>
                          <!-- contact button -->
                          <a class="call-btn-style-2  slider-button" <?php echo esc_attr($contactLink); ?> <?php echo esc_attr($contactTarget); ?> <?php echo esc_attr($contactRel); ?>>
                            <?php if (!empty($item['tj_contact_btn_icon']['value'])): ?>
                              <span class="icon"><?php tj_render_icon($item, "contact_btn_icon", "tj_contact_btn_icon"); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($tjSliderContactBtnText)): ?>
                              <span class="text"><?php echo esc_html__($tjSliderContactBtnText, 'tjcore'); ?></span>
                            <?php endif; ?>
                          </a>
                        <?php endif; ?>
                      </div>

                    </div>

                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; ?>

      </div>

      <?php if ($slideNav === 'yes'): ?>
        <div class="tj-navigation">
          <div class="tj-btn tj-btn-prev"> <svg viewBox="0 0 48 48">
              <circle cx="24" cy="24" r="20"></circle>
            </svg>
            <svg viewBox="0 0 48 48">
              <circle cx="24" cy="24" r="20"></circle>
            </svg><i class="tji-arrow-left"></i>
          </div>

          <div class="tj-btn tj-btn-next"> <svg viewBox="0 0 48 48">
              <circle cx="24" cy="24" r="20"></circle>
            </svg>
            <svg viewBox="0 0 48 48">
              <circle cx="24" cy="24" r="20"></circle>
            </svg> <i class="tji-arrow-right"></i>
          </div>
        </div>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <div class="tj-hero-shape"></div>
</section>