<?php
// title
$tjBannerTitle = $settings['tj_hero_banner_title'] ?? "";
$tjBannerTitleTag = $settings['tj_hero_banner_title_tag'] ?? "h1";
$tjTitleAnimation = $settings['tj_title_animation'] ?? '';

// desc
$tjBannerDesc = $settings['tj_hero_banner_description'] ?? "";
$tjDescAnimation = $settings['tj_description_animation'] ?? '';
$tjDescAnimationName = $settings['tj_description_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_description_animation_delay']['size'] ?? '';

$tjBannerImage = $settings['tj_hero_banner_image'] ?? '';
$tj_shape_show = $settings['tj_shape_show'] ?? '';
$tjImageAnimation   = $settings['tj_image_animation'] ?? '';
$tjImageAnimationName   = $settings['tj_image_animation_name'] ?? '';
$tjImageAnimationDelay   = $settings['tj_image_animation_delay']['size'] ?? '';

$imageClass = "hero-images-box";
if (!empty($tjImageAnimation)) {
  $imageClass .= " wow $tjImageAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', "{$tjImageAnimationDelay}s");
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay']['size'] ?? '';

// video popup
$tjVideoIcon = $settings['tj_video_icon'] ?? "";
$tjVideoImage = $settings['tj_video_image'] ?? "";
$tjVideoLink = $settings['tj_video_link'] ?? "";

$tjBannerScrollText = $settings['tj_hero_banner_scroll_text'] ?? "";

// title animation
$titleClass = "hero-title";
if (!empty($tjTitleAnimation)) {
  $titleClass .= " text-anim";
}
$this->add_render_attribute('tj_title_args', 'class', $titleClass);

// desc animation
$descClass = "desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', "{$tjDescAnimationDelay}s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// button
$heroBtnClass = "tj-primary-btn hero-button";
if (!empty($tjButtonAnimation)) {
  $heroBtnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', "{$tjButtonAnimationDelay}s");
}
$this->add_render_attribute('tj_button_arg', 'class', $heroBtnClass);

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
?>

<!-- start: Hero Section -->
<?php if ("yes" == $settings['tj_hero_banner_parallax']): ?>
  <div class="heroStack">
    <div class="stackOverlay"></div>
  <?php endif; ?>
  <div class="tj-hero-section">
    <div class="container">
      <div class="row">
        <div class="hero-wrapper">
          <div class="hero-content tj-hero-content">
            <!-- title -->
            <?php if (!empty($tjBannerTitle)) :
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($tjBannerTitleTag),
                $this->get_render_attribute_string('tj_title_args'),
                tj_kses($tjBannerTitle)
              );
            endif; ?>
            <!-- desc -->
            <?php if (!empty($tjBannerDesc)): ?>
              <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
                <?php echo tj_kses($tjBannerDesc); ?>
              </div>
            <?php endif; ?>
            <!-- button -->
            <?php if ($tjButtonShow === 'yes'): ?>
              <div class="tj-hero-btn">
                <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                  <span class="btn_inner">
                    <?php if (!empty($tjBtnIcon['value'])): ?>
                      <span class="btn_icon">
                        <span>
                          <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                          <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                        </span>
                      </span>
                    <?php endif; ?>
                    <?php if (!empty($tjBtnText)): ?>
                      <span class="btn_text">
                        <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
                      </span>
                    <?php endif; ?>
                  </span>
                </a>
              </div>
            <?php endif; ?>
            <?php if (!empty($tj_shape_show)): ?>
              <!-- shpae image -->
              <div class="hero-shapes-1 move-anim">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/hero-1.png" alt="Shapes">
              </div>
              <div class="hero-shapes-2 zoominout">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/hero-3.png" alt="Shapes">
              </div>
            <?php endif; ?>
          </div>
          <!-- image -->
          <div <?php $this->print_render_attribute_string("tj_image_arg"); ?>>
            <?php if (!empty($tjBannerImage['url'])): ?>
              <div class="hero-images">
                <img src="<?php echo esc_url($tjBannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjBannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />
              </div>
            <?php endif; ?>
            <?php if (!empty($tj_shape_show)): ?>
              <!-- shape image -->
              <div class="images-shapes move-anim-2">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/hero-2.png" alt="Shapes">
              </div>
            <?php endif; ?>
            <?php if (!empty($tjVideoLink)): ?>
              <!-- video popup -->
              <div class="hero-circle">
                <div class="circle-wrap el-circle">
                  <img class="rotate-image" src="<?php echo esc_url($tjVideoImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjVideoImage['id'], '_wp_attachment_image_alt', true)); ?>">
                  <?php if ($tjVideoIcon['value']): ?>
                    <a class="circle video-popup" data-autoplay="true" data-vbtype="video" data-maxwidth="1200px" id="video_popup-<?php echo esc_attr($this->get_id()); ?>"
                      href="<?php echo esc_url($tjVideoLink); ?>">
                      <?php tj_render_icon($settings, 'video_icon', 'tj_video_icon') ?>
                    </a>
                  <?php endif; ?>
                </div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
    <!-- scroll text -->
    <?php if ("yes" == $settings['tj_scroll_down_show'] && !empty($tjBannerScrollText)): ?>
      <div class="hero_scroll d-none d-lg-block">
        <a class="down" href="<?php echo esc_attr($settings['tj_banner_scroll_link']); ?>">
          <span><i class="tji-arrow-bown"></i></span>
          <?php echo esc_html__($tjBannerScrollText, 'tjcore'); ?>
        </a>
      </div>
    <?php endif; ?>
  </div>
  <?php if ("yes" == $settings['tj_hero_banner_parallax']): ?>
  </div>
<?php endif; ?>
<!-- end: Hero Section -->