<?php
// title
$tjBannerTitle = $settings['tj_hero_banner_title'] ?? "";
$tjBannerTitleTag = $settings['tj_hero_banner_title_tag'] ?? "h1";
$tjTitleAnimation = $settings['tj_title_animation'] ?? '';

// desc
$tjBannerDesc = $settings['tj_hero_banner_description'] ?? "";
$tjDescAnimation = $settings['tj_description_animation'] ?? '';
$tjDescAnimationName = $settings['tj_description_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_description_animation_delay']['size'] ?? '';

$tjBannerImage = $settings['tj_hero_banner_image'] ?? '';
$tj_shape_show = $settings['tj_shape_show'] ?? '';
$tjImageAnimation   = $settings['tj_image_animation'] ?? '';
$tjImageAnimationName   = $settings['tj_image_animation_name'] ?? '';
$tjImageAnimationDelay   = $settings['tj_image_animation_delay']['size'] ?? '';

$imageClass = "hero-images-box-two style-2";
if (!empty($tjImageAnimation)) {
  $imageClass .= " wow $tjImageAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', "{$tjImageAnimationDelay}s");
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// shape image
$smallShape = $settings['tj_small_shape'] ?? '';
$largeShape = $settings['tj_large_shape'] ?? '';

// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay']['size'] ?? '';


// title animation
$titleClass = "hero-title";
if (!empty($tjTitleAnimation)) {
  $titleClass .= " text-anim";
}
$this->add_render_attribute('tj_title_args', 'class', $titleClass);

// desc animation
$descClass = "desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', "{$tjDescAnimationDelay}s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// button
$heroBtnClass = "hero-btn";
if (!empty($tjButtonAnimation)) {
  $heroBtnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', "{$tjButtonAnimationDelay}s");
}
$this->add_render_attribute('tj_button_arg', 'class', $heroBtnClass);

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
?>

<!-- start: Hero Section -->
<section class="tj-hero-section-two">
  <div class="container">
    <div class="row">
      <div class="hero-wrapper-two">
        <div class="hero-content-two tj-hero-content">
          <!-- title -->
          <?php if (!empty($tjBannerTitle)) :
            printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($tjBannerTitleTag),
              $this->get_render_attribute_string('tj_title_args'),
              tj_kses($tjBannerTitle)
            );
          endif; ?>
          <!-- desc -->
          <?php if (!empty($tjBannerDesc)): ?>
            <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
              <?php echo tj_kses($tjBannerDesc); ?>
            </div>
          <?php endif; ?>

        </div>
        <?php if (!empty($tj_shape_show) && !empty($smallShape['url'])): ?>
          <span class="shape-1 zoominout">
            <img src="<?php echo esc_url($smallShape['url']); ?>" alt="<?php echo esc_attr(get_post_meta($smallShape['id'], '_wp_attachment_image_alt', true)); ?>" />
          </span>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div <?php $this->print_render_attribute_string("tj_image_arg"); ?>>
          <?php if (!empty($tjBannerImage['url'])): ?>
            <img src="<?php echo esc_url($tjBannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjBannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />
          <?php endif; ?>
          <div class="hero-button el-circle">
            <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
              <?php if (!empty($tjBtnIcon['value'])): ?>
                <span class="blue">
                  <span><?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                    <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?></span>
                </span>
              <?php endif; ?>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php if (!empty($tj_shape_show) && !empty($largeShape['url'])): ?>
    <div class="hero_shapes">
      <img src="<?php echo esc_url($largeShape['url']); ?>" alt="<?php echo esc_attr(get_post_meta($largeShape['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
</section>
<!-- end: Hero Section -->