<?php
// subtitle
$tjBannerSubtitle = $settings['tj_hero_banner_subtitle'] ?? "";
$tjSubtitleAnimation = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay = $settings['tj_subtitle_animation_delay']['size'] ?? '';

$subtitleClass = "hero-subtitle";
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass .= " wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj_subtitle_args', 'data-wow-delay', "{$tjSubtitleAnimationDelay}s");
}
$this->add_render_attribute('tj_subtitle_args', 'class', $subtitleClass);

// title
$tjBannerTitle = $settings['tj_hero_banner_title'] ?? "";
$tjBannerTitleTag = $settings['tj_hero_banner_title_tag'] ?? "";
$tjTitleAnimation = $settings['tj_title_animation'] ?? '';

$titleClass = "hero-title";
if (!empty($tjTitleAnimation)) {
  $titleClass .= " text-anim";
}
$this->add_render_attribute('tj_title_args', 'class', $titleClass);

// desc
$tjBannerDesc = $settings['tj_hero_banner_description'] ?? "";
$tjDescAnimation = $settings['tj_description_animation'] ?? '';
$tjDescAnimationName = $settings['tj_description_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_description_animation_delay']['size'] ?? '';

$descClass = "desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', "{$tjDescAnimationDelay}s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);


// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay']['size'] ?? '';

$heroBtnClass = "tj-primary-btn hero-button";
if (!empty($tjButtonAnimation)) {
  $heroBtnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', "{$tjButtonAnimationDelay}s");
}
$this->add_render_attribute('tj_button_arg', 'class', $heroBtnClass);

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}

// main image
$tjBannerImage = $settings['tj_hero_banner_image'] ?? '';
$tjImageAnimation   = $settings['tj_image_animation'] ?? '';
$tjImageAnimationName   = $settings['tj_image_animation_name'] ?? '';
$tjImageAnimationDelay   = $settings['tj_image_animation_delay']['size'] ?? '';

$imageClass = "hero-images";
if (!empty($tjImageAnimation)) {
  $imageClass .= " wow $tjImageAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', "{$tjImageAnimationDelay}s");
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// shape 1
$tj_shape_1_show = $settings['tj_shape_1_show'] ?? '';
$tjShape1Image = $settings['tj_shape_1_image'] ?? '';
$tjShape1Animation   = $settings['tj_shape_1_animation'] ?? '';
$tjShape1AnimationName   = $settings['tj_shape_1_animation_name'] ?? '';
$tjShape1AnimationDelay   = $settings['tj_shape_1_animation_delay']['size'] ?? '';

$shape1Class = "hero-shapes-1";
if (!empty($tjShape1Animation)) {
  $shape1Class .= " wow $tjShape1AnimationName";
  $this->add_render_attribute('tj_shape1_arg', 'data-wow-delay', "{$tjShape1AnimationDelay}s");
}
$this->add_render_attribute('tj_shape1_arg', 'class', $shape1Class);

// shape 2
$tj_shape_2_show = $settings['tj_shape_2_show'] ?? '';
$tjShape2Image = $settings['tj_shape_2_image'] ?? '';
$tjShape2Animation   = $settings['tj_shape_2_animation'] ?? '';
$tjShape2AnimationName   = $settings['tj_shape_2_animation_name'] ?? '';
$tjShape2AnimationDelay   = $settings['tj_shape_2_animation_delay']['size'] ?? '';

$shape2Class = "hero-shapes-2";
if (!empty($tjShape2Animation)) {
  $shape2Class .= " wow $tjShape2AnimationName";
  $this->add_render_attribute('tj_shape2_arg', 'data-wow-delay', "{$tjShape2AnimationDelay}s");
}
$this->add_render_attribute('tj_shape2_arg', 'class', $shape2Class);

// video
$tjVideoIcon = $settings['tj_video_icon'] ?? "";
$tjVideoLink = $settings['tj_video_link'] ?? "";
$tjVideoText = $settings['tj_video_text'] ?? "";

// highlight
$tjHighlightShow = $settings['tj_highlight_show'] ?? "";
$tjHighlightContent = $settings['tj_highlight_content'] ?? "";
$tjHighlightTitle = $settings['tj_highlight_title'] ?? "";
?>


<section class="tj-hero-section-four">
  <div class="container">
    <div class="row">
      <div class="hero-wrapper-four">
        <div class="hero-content-four">
          <?php if (!empty($tjBannerSubtitle)): ?>
            <!-- subtitle -->
            <span <?php $this->print_render_attribute_string("tj_subtitle_args"); ?>>
              <?php echo tj_kses($tjBannerSubtitle); ?>
            </span>
          <?php endif; ?>

          <!-- title -->
          <?php if (!empty($tjBannerTitle)) :
            printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($tjBannerTitleTag),
              $this->get_render_attribute_string('tj_title_args'),
              tj_kses($tjBannerTitle)
            );
          endif; ?>

          <?php if (!empty($tjBannerDesc)): ?>
            <!-- desc -->
            <div <?php $this->print_render_attribute_string('tj_desc_args'); ?>>
              <?php echo tj_kses($tjBannerDesc); ?>
            </div>
          <?php endif; ?>

          <?php if ($tjButtonShow === 'yes'): ?>
            <div class="tj-hero-btn">
              <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                <span class="btn_inner">
                  <?php if (!empty($tjBtnIcon['value'])): ?>
                    <span class="btn_icon">
                      <span>
                        <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                        <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                      </span>
                    </span>
                  <?php endif; ?>
                  <?php if (!empty($tjBtnText)): ?>
                    <span class="btn_text">
                      <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
                    </span>
                  <?php endif; ?>
                </span>
              </a>
            </div>
          <?php endif; ?>

        </div>

        <div class="hero-images-box-four">

          <?php if (!empty($tjBannerImage['url'])): ?>
            <div <?php $this->print_render_attribute_string("tj_image_arg"); ?>>
              <img src="<?php echo esc_url($tjBannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjBannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          <?php endif; ?>

          <?php if (!empty($tjHighlightShow)): ?>
            <!-- highlight -->
            <div class="client-experience move-anim">
              <?php echo tj_kses($tjHighlightContent); ?>
              <?php if (!empty($tjHighlightTitle)): ?>
                <span class="sub-title"><?php echo tj_kses($tjHighlightTitle); ?></span>
              <?php endif; ?>
            </div>
          <?php endif; ?>

          <?php if (!empty($tjVideoLink)): ?>
            <!-- video -->
            <div class="hero-video-btn move-anim">
              <a class="video-btn video-popup" data-autoplay="true" data-vbtype="video" data-maxwidth="1200px" id="video_popup-<?php echo esc_attr($this->get_id()); ?>"
                href="<?php echo esc_url($tjVideoLink); ?>">
                <?php if ($tjVideoIcon['value']): ?>
                  <span class="play-btn"><?php tj_render_icon($settings, 'video_icon', 'tj_video_icon') ?></span>
                <?php endif; ?>
                <?php if ($tjVideoText): ?>
                  <span class="video-text"><?php echo tj_kses($tjVideoText); ?></span>
                <?php endif; ?>
              </a>
            </div>
          <?php endif; ?>
        </div>


        <?php if (!empty($tjShape1Image['url'])): ?>
          <!-- shape 1 -->
          <div <?php $this->print_render_attribute_string("tj_shape1_arg"); ?>>
            <img src="<?php echo esc_url($tjShape1Image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjShape1Image['id'], '_wp_attachment_image_alt', true)); ?>" />
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>


  <?php if (!empty($tjShape2Image['url'])): ?>
    <!-- shape 2 -->
    <div <?php $this->print_render_attribute_string("tj_shape2_arg"); ?>>
      <img src="<?php echo esc_url($tjShape2Image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjShape2Image['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
</section>