<?php
// title
$tjBannerTitle = $settings['tj_hero_banner_title'] ?? "";
$tjBannerTitleTag = $settings['tj_hero_banner_title_tag'] ?? "h1";
$tjTitleAnimation = $settings['tj_title_animation'] ?? '';

// desc
$tjBannerDesc = $settings['tj_hero_banner_description'] ?? "";
$tjDescAnimation = $settings['tj_description_animation'] ?? '';
$tjDescAnimationName = $settings['tj_description_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_description_animation_delay']['size'] ?? '';

$tjBannerImage = $settings['tj_hero_banner_image'] ?? '';
$bannerBgimage = $settings['tj_hero_bg_image'] ?? '';
$tjImageAnimation   = $settings['tj_image_animation'] ?? '';
$tjImageAnimationName   = $settings['tj_image_animation_name'] ?? '';
$tjImageAnimationDelay   = $settings['tj_image_animation_delay']['size'] ?? '';

$imageClass = "h8-hero-banner";
if (!empty($tjImageAnimation)) {
  $imageClass .= " wow $tjImageAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', "{$tjImageAnimationDelay}s");
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// title animation
$titleClass = "slider-title h8-hero-title";
if (!empty($tjTitleAnimation)) {
  $titleClass .= " hero-text-anim";
}
$this->add_render_attribute('tj_title_args', 'class', $titleClass);

// desc animation
$descClass = "desc h8-hero-desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', "{$tjDescAnimationDelay}s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);


// highlight
$tjHighlightShow = $settings['tj_highlight_show'] ?? "";
$tjHighlightContent = $settings['tj_highlight_content2'] ?? "";

?>

<!-- start: Hero Section -->
<section class="h8-hero style-1">
  <div class="tj-slider-section h8-hero-inner " <?php if (!empty($bannerBgimage['url'])) { ?> data-bg-image="<?php echo esc_url($bannerBgimage['url']); ?>" <?php }; ?>>
    <div class="container">
      <div class="row">
        <div class="slider-wrapper h8-hero-wrapper">
          <div class="slider-content h8-hero-content">
            <div class="h8-hero-title-wrapper">

              <!-- title -->
              <?php if (!empty($tjBannerTitle)) :
                printf(
                  '<%1$s %2$s>%3$s</%1$s>',
                  tag_escape($tjBannerTitleTag),
                  $this->get_render_attribute_string('tj_title_args'),
                  tj_kses($tjBannerTitle)
                );
              endif; ?>
              <?php if (!empty($tjHighlightShow)): ?>
                <div class="about-circle h8-hero-circle wow zoomIn" data-wow-delay="1.8s">
                  <?php echo tj_kses($tjHighlightContent); ?>
                </div>
              <?php endif; ?>
            </div>

            <!-- desc -->
            <?php if (!empty($tjBannerDesc)): ?>
              <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
                <?php echo tj_kses($tjBannerDesc); ?>
              </div>
            <?php endif; ?>

            <?php if (!empty($tjBannerImage['url'])): ?>
              <div <?php $this->print_render_attribute_string("tj_image_arg"); ?>>
                <img src="<?php echo esc_url($tjBannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjBannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>

</section>







<!-- end: Hero Section -->