<?php

// subtitle
$tjBannerSubtitle = $settings['tj_hero_banner_subtitle'] ?? "";
$tjSubtitleAnimation = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay = $settings['tj_subtitle_animation_delay']['size'] ?? '';

$subtitleClass = "hero-sub-title";
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass .= " wow $tjSubtitleAnimationName";
  $this->add_render_attribute('tj_subtitle_args', 'data-wow-delay', "{$tjSubtitleAnimationDelay}s");
}
$this->add_render_attribute('tj_subtitle_args', 'class', $subtitleClass);


// title
$tjBannerTitle = $settings['tj_hero_banner_title'] ?? "";
$tjBannerTitleTag = $settings['tj_hero_banner_title_tag'] ?? "h1";
$tjTitleAnimation = $settings['tj_title_animation'] ?? '';

// desc
$tjBannerDesc = $settings['tj_hero_banner_description'] ?? "";
$tjDescAnimation = $settings['tj_description_animation'] ?? '';
$tjDescAnimationName = $settings['tj_description_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_description_animation_delay']['size'] ?? '';

$tjBannerImage = $settings['tj_hero_banner_image'] ?? '';
$bannerBgimage = $settings['tj_hero_bg_image'] ?? '';
$tjImageAnimation   = $settings['tj_image_animation'] ?? '';
$tjImageAnimationName   = $settings['tj_image_animation_name'] ?? '';
$tjImageAnimationDelay   = $settings['tj_image_animation_delay']['size'] ?? '';

$imageClass = "h9-hero-banner";
if (!empty($tjImageAnimation)) {
  $imageClass .= " wow $tjImageAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', "{$tjImageAnimationDelay}s");
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// title animation
$titleClass = "hero-title";
if (!empty($tjTitleAnimation)) {
  $titleClass .= " text-anim";
}
$this->add_render_attribute('tj_title_args', 'class', $titleClass);

// desc animation
$descClass = "desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', "{$tjDescAnimationDelay}s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// shape image
$tj_shape_1_show = $settings['tj_shape_1_show'] ?? '';
$tjShape1Image = $settings['tj_shape_1_image'] ?? '';
$tjShape1Animation   = $settings['tj_shape_1_animation'] ?? '';
$tjShape1AnimationName   = $settings['tj_shape_1_animation_name'] ?? '';
$tjShape1AnimationDelay   = $settings['tj_shape_1_animation_delay']['size'] ?? '';

$shape1Class = "h9-hero-chart move-anim";
if (!empty($tjShape1Animation)) {
  $shape1Class .= " wow $tjShape1AnimationName";
  $this->add_render_attribute('tj_shape1_arg', 'data-wow-delay', "{$tjShape1AnimationDelay}s");
}
$this->add_render_attribute('tj_shape1_arg', 'class', $shape1Class);


// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay']['size'] ?? '';

$heroBtnClass = "tj-primary-btn hero-button";
if (!empty($tjButtonAnimation)) {
  $heroBtnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', "{$tjButtonAnimationDelay}s");
}
$this->add_render_attribute('tj_button_arg', 'class', $heroBtnClass);

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}

$tj_hero_text_btn = $settings['tj_hero_text_btn'] ?? '';
$tj_hero_text_btn_link = !empty($settings['tj_hero_text_btn_link']['url']) ? $settings['tj_hero_text_btn_link']['url'] : '';


$tj_marquee_show = $settings['tj_marquee_show'] ?? [];
$marqueeList = $settings['tj_marquee_list'] ?? [];
$marqueeSlide  = $settings['marquee_slide'] ?? "";

if ('right-to-left' == $marqueeSlide) {
  $slideContent = "";
} else {
  $slideContent = "dir=rtl";
}

?>

<!-- start: Hero Section -->

<section class="h9-hero">
  <?php if (!empty($tj_marquee_show)) : ?>
    <div class="h9-hero-marquee-wrapper">
      <div class="h9-hero-marquee">
        <div class="marquee-slider-wrapper">
          <div class="swiper h9-hero-marquee-slider" <?php echo esc_attr($slideContent); ?> id="marquee-<?php echo $this->get_id(); ?>">
            <div class="swiper-wrapper marquee-wrapper">

              <?php foreach ($marqueeList as $item) :
                $icon = $item['tj_marquee_icon'] ?? '';
                $title = $item['tj_marquee_title'] ?? '';
              ?>
                <div class="swiper-slide marquee-item">
                  <?php if (!empty($title)): ?>
                    <div class="marquee-title">
                      <h3 class="text"><?php echo tj_kses($title); ?></h3>
                    </div>
                  <?php endif; ?>
                  <?php if (!empty($icon['value'])): ?>
                    <div class="marquee-icons">
                      <?php tj_render_icon($item, 'marquee_icon', 'tj_marquee_icon') ?>
                    </div>
                  <?php endif; ?>
                </div>
              <?php endforeach; ?>

            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
  <?php if (!empty($bannerBgimage['url'])): ?>
    <div class="h9-hero-bg" data-bg-image="<?php echo esc_url($bannerBgimage['url']); ?>"></div>
  <?php endif; ?>
  <!-- hero content -->
  <div class="h9-hero-wrapper ">
    <div class="container tj-gap-0">
      <div class="row align-items-center">
        <div class="col-12 col-lg-6">
          <div class="h9-hero-content-wrapper" <?php if (!empty($bannerBgimage['url'])) { ?> data-bg-image="<?php echo esc_url($bannerBgimage['url']); ?>" <?php }; ?>>
            <div class="h9-hero-content">

              <?php if (!empty($tjBannerSubtitle)): ?>
                <!-- subtitle -->
                <span <?php $this->print_render_attribute_string("tj_subtitle_args"); ?>>
                  <?php echo tj_kses($tjBannerSubtitle); ?>
                </span>
              <?php endif; ?>

              <?php if (!empty($tjBannerTitle)) :
                printf(
                  '<%1$s %2$s>%3$s</%1$s>',
                  tag_escape($tjBannerTitleTag),
                  $this->get_render_attribute_string('tj_title_args'),
                  tj_kses($tjBannerTitle)
                );
              endif; ?>

              <?php if (!empty($tjBannerDesc)): ?>
                <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
                  <?php echo tj_kses($tjBannerDesc); ?>
                </div>
              <?php endif; ?>
              <?php if (!empty($tjButtonShow)): ?>
                <div class="h9-hero-action">
                  <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                    <span class="btn_inner">
                      <?php if (!empty($tjBtnIcon['value'])): ?>
                        <span class="btn_icon">
                          <span>
                            <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                            <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                          </span>
                        </span>
                      <?php endif; ?>
                      <?php if (!empty($tjBtnText)): ?>
                        <span class="btn_text">
                          <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
                        </span>
                      <?php endif; ?>
                    </span>
                  </a>
                  <?php if (!empty($tj_hero_text_btn)): ?>
                    <a class="service-button text-btn wow fadeInUp" data-wow-delay="0.3s" href="<?php echo esc_url($tj_hero_text_btn_link); ?>">
                      <?php echo esc_html__($tj_hero_text_btn, 'tjcore'); ?> <?php tj_render_icon($settings, 'tj_hero_text_btn_icon') ?>
                    </a>
                  <?php endif; ?>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
        <div class="col-12 col-lg-6">
          <div class="h9-hero-banner-wrapper">
            <div <?php $this->print_render_attribute_string("tj_image_arg"); ?>>
              <?php if (!empty($tjBannerImage['url'])): ?>
                <img src="<?php echo esc_url($tjBannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjBannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />
              <?php endif; ?>

              <?php if (!empty($tjShape1Image['url'])): ?>
                <div class="h9-hero-chart-wrapper">
                  <div <?php $this->print_render_attribute_string("tj_shape1_arg"); ?>>
                    <img src="<?php echo esc_url($tjShape1Image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjShape1Image['id'], '_wp_attachment_image_alt', true)); ?>" />
                  </div>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- end: Hero Section -->