<?php

// title
$tjBannerTitle = $settings['tj_hero_banner_title'] ?? "";
$tjBannerTitleTag = $settings['tj_hero_banner_title_tag'] ?? "h1";
$tjTitleAnimation = $settings['tj_title_animation'] ?? '';

// desc
$tjBannerDesc = $settings['tj_hero_banner_description'] ?? "";
$tjDescAnimation = $settings['tj_description_animation'] ?? '';
$tjDescAnimationName = $settings['tj_description_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_description_animation_delay']['size'] ?? '';

// image
$bannerBgimage = $settings['tj_hero_bg_image'] ?? '';


// title animation
$titleClass = "hero-title";
if (!empty($tjTitleAnimation)) {
  $titleClass .= " hero-text-anim";
}
$this->add_render_attribute('tj_title_args', 'class', $titleClass);

// desc animation
$descClass = "desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', "{$tjDescAnimationDelay}s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// shape image
$tj_shape_1_show = $settings['tj_shape_1_show'] ?? '';
$tjShape1Image = $settings['tj_shape_1_image'] ?? '';
$tjShape1Animation   = $settings['tj_shape_1_animation'] ?? '';
$tjShape1AnimationName   = $settings['tj_shape_1_animation_name'] ?? '';
$tjShape1AnimationDelay   = $settings['tj_shape_1_animation_delay']['size'] ?? '';

$shape1Class = "h10-hero-sroll-down";
if (!empty($tjShape1Animation)) {
  $shape1Class .= " wow $tjShape1AnimationName";
  $this->add_render_attribute('tj_shape1_arg', 'data-wow-delay', "{$tjShape1AnimationDelay}s");
}
$this->add_render_attribute('tj_shape1_arg', 'class', $shape1Class);


// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay']['size'] ?? '';

$heroBtnClass = "tj-primary-btn hero-button";
if (!empty($tjButtonAnimation)) {
  $heroBtnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', "{$tjButtonAnimationDelay}s");
}
$this->add_render_attribute('tj_button_arg', 'class', $heroBtnClass);

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}

$chart_bg_color = !empty($settings['chart_bg_color']) ?  $settings['chart_bg_color'] : '';
$chart_bg_color2 = !empty($settings['chart_bg_color2']) ?  $settings['chart_bg_color2'] : '';
$chart_bg_color3 = !empty($settings['chart_bg_color3']) ?  $settings['chart_bg_color3'] : '';

?>

<section class=" h10-hero style-1">
  <div class="tj-slider-section h10-hero-inner" <?php if (!empty($bannerBgimage['url'])) { ?> data-bg-image="<?php echo esc_url($bannerBgimage['url']); ?>" <?php }; ?>>
    <div class="container">
      <div class="row">
        <div class="slider-wrapper h10-hero-wrapper">
          <div class="h10-hero-content">
            <?php if (!empty($tjBannerTitle)) :
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($tjBannerTitleTag),
                $this->get_render_attribute_string('tj_title_args'),
                tj_kses($tjBannerTitle)
              );
            endif; ?>

            <?php if (!empty($tjBannerDesc)): ?>
              <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
                <?php echo tj_kses($tjBannerDesc); ?>
              </div>
            <?php endif; ?>

            <?php if (!empty($tjShape1Image['url'])): ?>
              <div <?php $this->print_render_attribute_string("tj_shape1_arg"); ?>>
                <div class="h10-hero-sroll-down-icon">
                  <img src="<?php echo esc_url($tjShape1Image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjShape1Image['id'], '_wp_attachment_image_alt', true)); ?>" />
                </div>
              </div>
            <?php endif; ?>

            <div class="h10-hero-stat d-xl-none">
              <?php if (!empty($tj_chart_title) || !empty($ending_number) || !empty($tj_counter_desc)): ?>
                <div class="h10-hero-stat-inner">
                  <div class="h10-hero-stat-chart">
                    <canvas class="tj-pie-chart" data-color='["<?php echo esc_attr($chart_bg_color); ?>", "<?php echo esc_attr($chart_bg_color2); ?>", "<?php echo esc_attr($chart_bg_color3); ?>"]'></canvas>

                    <?php if (!empty($tj_chart_title)): ?>
                      <p class="h10-hero-stat-chart-text"><?php echo tj_kses($tj_chart_title); ?></p>
                    <?php endif; ?>
                  </div>
                  <div class="h10-hero-stat-counter">
                    <div class="h10-hero-counter-item">
                      <div class="number">
                        <?php if (!empty($ending_number)): ?>
                          <span data-purecounter-start="0" data-purecounter-end="<?php echo esc_attr($ending_number); ?>" class="purecounter"><?php echo esc_attr($ending_number); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($Suffix)): ?>
                          <sup><?php echo tj_kses($Suffix); ?></sup>
                        <?php endif; ?>
                      </div>
                      <?php if (!empty($tj_counter_desc)): ?>
                        <span class="sub-title"><?php echo tj_kses($tj_counter_desc); ?></span>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              <?php endif; ?>

              <?php if (!empty($tjButtonShow)): ?>
                <div class="h10-hero-stat-action">
                  <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                    <span class="btn_inner">
                      <?php if (!empty($tjBtnIcon['value'])): ?>
                        <span class="btn_icon">
                          <span>
                            <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                            <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                          </span>
                        </span>
                      <?php endif; ?>
                      <?php if (!empty($tjBtnText)): ?>
                        <span class="btn_text">
                          <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
                        </span>
                      <?php endif; ?>
                    </span>
                  </a>
                </div>
              <?php endif; ?>
            </div>
          </div>
          <!-- d-xl-block -->
          <div class="h10-hero-stat d-none d-xl-block">
            <?php if (!empty($tj_chart_title) || !empty($ending_number) || !empty($tj_counter_desc)): ?>
              <div class="h10-hero-stat-inner">
                <div class="h10-hero-stat-chart">
                  <canvas class="tj-pie-chart" data-color='["<?php echo esc_attr($chart_bg_color); ?>", "<?php echo esc_attr($chart_bg_color2); ?>", "<?php echo esc_attr($chart_bg_color3); ?>"]'></canvas>
                  <?php if (!empty($tj_chart_title)): ?>
                    <p class="h10-hero-stat-chart-text"><?php echo tj_kses($tj_chart_title); ?></p>
                  <?php endif; ?>
                </div>
                <div class="h10-hero-stat-counter">
                  <div class="h10-hero-counter-item">
                    <div class="number">
                      <?php if (!empty($ending_number)): ?>
                        <span data-purecounter-start="0" data-purecounter-end="<?php echo esc_attr($ending_number); ?>" class="purecounter"><?php echo esc_attr($ending_number); ?></span>
                      <?php endif; ?>

                      <?php if (!empty($Suffix)): ?>
                        <sup><?php echo tj_kses($Suffix); ?></sup>
                      <?php endif; ?>

                    </div>
                    <?php if (!empty($tj_counter_desc)): ?>
                      <span class="sub-title"><?php echo tj_kses($tj_counter_desc); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
            <?php if (!empty($tjButtonShow)): ?>
              <div class="h10-hero-stat-action">
                <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                  <span class="btn_inner">
                    <?php if (!empty($tjBtnIcon['value'])): ?>
                      <span class="btn_icon">
                        <span>
                          <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                          <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                        </span>
                      </span>
                    <?php endif; ?>
                    <?php if (!empty($tjBtnText)): ?>
                      <span class="btn_text">
                        <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
                      </span>
                    <?php endif; ?>
                  </span>
                </a>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>