<?php
$sliderImages   = (!empty($settings['tj_image_list'])) ? $settings['tj_image_list'] : "";

$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay        = (isset($settings['slide_autoplay_Delay']) && !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000');

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $brandsClass = "h6-slider-area carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj_slider_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $brandsClass = "h6-slider-area carouselWrap";
}
$this->add_render_attribute('tj_slider_arg', 'class', $brandsClass);

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

?>

<div <?php echo $this->get_render_attribute_string('tj_slider_arg'); ?> data-loop="<?php echo $loop; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <?php if (!empty($sliderImages)): ?>
    <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper swiper-container h6-hero-slider" id="imageSlider-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper h6-slider-wrapper">
        <?php foreach ($sliderImages as $imageItem):
          $image = $imageItem['tj_slider_image'];
        ?>
          <div class="swiper-slide h6-slider-item">
            <div class="slider-img">
              <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>" />
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  <?php endif; ?>
</div>