<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

// include_categories
$category_list = '';
if (!empty($settings['category'])) {
  $category_list = implode(", ", $settings['category']);
}
$category_list_value = explode(" ", $category_list);

// exclude_categories
$exclude_categories = '';
if (!empty($settings['exclude_category'])) {
  $exclude_categories = implode(", ", $settings['exclude_category']);
}
$exclude_category_list_value = explode(" ", $exclude_categories);

// include_posts
$post__in = '';
if (!empty($settings['post__in'])) {
  $post__not_in = $settings['post__in'];
  $args['post__in'] = $post__in;
}

// exclude_posts
$post__not_in = '';
if (!empty($settings['post__not_in'])) {
  $post__not_in = $settings['post__not_in'];
  $args['post__not_in'] = $post__not_in;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';
$ignore_sticky_posts = (!empty($settings['ignore_sticky_posts']) && 'yes' == $settings['ignore_sticky_posts']) ? true : false;

// offset
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// Posts Include array
$pI_ids = [];
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// Posts Exclude array
$pE_ids = [];
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

// args
$args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
  'ignore_sticky_posts' => $ignore_sticky_posts
);

// exclude_categories
if (!empty($settings['exclude_category'])) {

  // Exclude the correct cats from tax_query
  $args['tax_query'] = array(
    array(
      'taxonomy'    => 'category',
      'field'         => 'slug',
      'terms'        => $exclude_category_list_value,
      'operator'    => 'NOT IN'
    )
  );

  // Include the correct cats in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query']['relation'] = 'AND';
    $args['tax_query'][] = array(
      'taxonomy'    => 'category',
      'field'        => 'slug',
      'terms'        => $category_list_value,
      'operator'    => 'IN'
    );
  }
} else {
  // Include the cats from $cat_slugs in tax_query
  if (!empty($settings['category'])) {
    $args['tax_query'][] = [
      'taxonomy' => 'category',
      'field' => 'slug',
      'terms' => $category_list_value,
    ];
  }
}

// The Query
$query = new \WP_Query($args);

// The Query
$query = new \WP_Query($args);
// animation
$tjAnimation      = $settings['tj_animation'];
$tjAnimationName  = $settings['tj_animation_name'];
$tjAnimationDelay = $settings['tj_animation_delay'];

$wrapClass = "blog-item blog-el-item";
if (!empty($tjAnimation)) {
  $wrapClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrapClass);

?>


<div class="tj_latest_blog">
  <?php if ($query->have_posts()) : ?>

    <div class="h7-blog-wrapper">
      <?php
      $n = 0;
      while ($query->have_posts()) :
        $n++;
        $query->the_post();
        global $post;
        $categories = get_the_terms(get_the_ID(), 'category');
      ?>
        <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
          <?php if (has_post_thumbnail()) : ?>
            <div class="blog-images hover:shine">
              <a href="<?php the_permalink($post->ID); ?>">
                <?php the_post_thumbnail('full'); ?>
              </a>
            </div>
          <?php endif; ?>

          <div class="blog-content">
            <div class="blog-meta blog-el-meta">
              <ul>
                <?php if ("yes" == $settings['tj_post_category'] && (!empty($categories[0]->name))): ?>
                  <li class="category">
                    <a href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>">
                      <?php echo esc_html($categories[0]->name); ?>
                    </a>
                  </li>
                <?php endif; ?>

                <?php if ("yes" == $settings['tj_post_date']) : ?>
                  <li><?php the_time('M d, Y', $post->ID); ?></li>
                <?php endif; ?>

                <?php if ("yes" == $settings['tj_post_comment']) : ?>
                  <li><?php comments_number(); ?></li>
                <?php endif; ?>
              </ul>
            </div>

            <h4 class="blog-title blog-el-title">
              <a href="<?php the_permalink($post->ID); ?>">
                <?php echo wp_trim_words(get_the_title($post->ID), $settings['tj_post_title_word'], '...'); ?>
              </a>
            </h4>

            <?php if (!empty($settings['tj_post_content'])) :
              $tj_post_content_limit = (!empty($settings['tj_post_content_limit'])) ? $settings['tj_post_content_limit'] : '';
            ?>
              <div class="desc"><?php echo wp_trim_words(get_the_content(get_the_ID()), $tj_post_content_limit, '...'); ?></div>
            <?php endif; ?>

          </div>
        </div>
      <?php endwhile;
      wp_reset_query(); ?>
    </div>
  <?php endif; ?>
</div>