<?php
$lists = !empty($settings['tj_list']) ? $settings['tj_list'] : [];

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
    $listClass = "service-check-list tj-el-list wow $tjAnimationName";
    $this->add_render_attribute('tj_list_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
    $listClass = "service-check-list tj-el-list";
}
$this->add_render_attribute('tj_list_arg', 'class', $listClass);
?>

<?php if (count($lists) > 0): ?>
    <div <?php echo $this->get_render_attribute_string('tj_list_arg'); ?>>
        <ul>
            <?php foreach ($lists as $item):
                $icon = !empty($item['tj_item_icon']) ? $item['tj_item_icon'] : '';
                $itemContent = !empty($item['tj_item_content']) ? $item['tj_item_content'] : '';
            ?>
                <li>
                    <?php if (!empty($icon['value'])) : ?>
                        <?php tj_render_icon($item, 'tj_icon', 'tj_item_icon') ?>
                    <?php endif; ?>
                    <span><?php echo tj_kses($itemContent);  ?></span>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>