<?php
$marqueeList = $settings['tj_list'] ?? [];
$marqueeSlide  = $settings['marquee_slide'] ?? "";

if ('right-to-left' == $marqueeSlide) {
  $slideContent = "";
} else {
  $slideContent = "dir=rtl";
}
?>

<?php if (!empty($marqueeList)) : ?>
  <!-- start: Marquee Section -->
  <section class="tj-marquee-section">
    <div class="marquee-slider-wrapper">
      <div class="swiper marquee-slider" <?php echo esc_attr($slideContent); ?> id="marquee-<?php echo $this->get_id(); ?>">
        <div class="swiper-wrapper marquee-wrapper">
          <?php foreach ($marqueeList as $item) :
            $icon = $item['tj_marquee_icon'] ?? '';
            $title = $item['tj_marquee_title'] ?? '';
          ?>
            <div class="swiper-slide marquee-item">
              <?php if (!empty($title)): ?>
                <div class="marquee-title">
                  <h3 class="text"><?php echo tj_kses($title); ?></h3>
                </div>
              <?php endif; ?>
              <?php if (!empty($icon['value'])): ?>
                <div class="marquee-icons">
                  <?php tj_render_icon($item, 'marquee_icon', 'tj_marquee_icon') ?>
                </div>
              <?php endif; ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </section>
  <!-- end: Marquee Section -->
<?php endif; ?>