<?php

$tj_title = $settings['tj_title'] ?? "";
$tj_header_navigation = $settings['tj_header_navigation'] ?? "";

$headerTitle = $tj_title ? $tj_title : get_the_title(get_the_ID());

$bgImage   = $settings['tj_image']['url'] ?? '';


// title animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $titleClass = "breadcrumb-title wow $tjAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $titleClass = "breadcrumb-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// nav animation
$tjNavAnimation   = $settings['tj_nav_animation'] ?? '';
$tjNavAnimationName   = $settings['tj_nav_animation_name'] ?? '';
$tjNavAnimationDelay   = $settings['tj_nav_animation_delay'] ?? '';

if (!empty($tjNavAnimation)) {
  $navClass = "breadcrumb-link wow $tjNavAnimationName";
  $this->add_render_attribute('nav_args', 'data-wow-delay', $tjNavAnimationDelay['size'] . "s");
} else {
  $navClass = "breadcrumb-link";
}
$this->add_render_attribute('nav_args', 'class', $navClass);

// image
if (!empty($bgImage)) {
  $bg_img = "data-bg-image='$bgImage'";
} else {
  $bg_img = "";
}
?>

<section class="breadcrumb-wrapper background-image" <?php echo esc_attr($bg_img); ?>>
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <div class="breadcrumb-content-area">

          <?php if (!empty($headerTitle)) : ?>
            <!-- title -->
            <div class="breadcrumb-heading">
              <?php printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($settings['tj_title_tag']),
                $this->get_render_attribute_string('title_args'),
                tj_kses($headerTitle)
              ); ?>
            </div>
          <?php endif; ?>

          <?php if (!empty($tj_header_navigation)) :

            if (function_exists('bcn_display')): ?>
              <!-- navigation -->
              <div <?php echo $this->get_render_attribute_string('nav_args'); ?>>
                <?php bcn_display(); ?>
              </div>
          <?php endif;
          endif; ?>

        </div>
      </div>
    </div>
  </div>
</section>