<?php
$priceTitle = $settings['price_title'] ?? "";
$priceSubtitle = $settings['price_subtitle'] ?? "";
$priceDescription =  $settings['price_description'] ?? "";
$priceCurrency = $settings['tj_price_currency'] ?? "";
$yearlyPrice = $settings['tj_yearly_price'] ?? "";
$monthlyPrice = $settings['tj_monthly_price'] ?? "";
$priceYearPeriod = $settings['tj_year_price_period'] ?? "";
$priceMonthPeriod = $settings['tj_month_price_period'] ?? "";


$isRecommended = !empty($settings['is_price_box_recommend']) ? "active" : "";

$featureList = $settings['tj_feature_list'] ?? "";

if ($priceCurrency === 'custom') {
  $currency = $settings['currency_custom'];
} else {
  $currency = self::get_currency_symbol($priceCurrency);
}

$tjBtnText = !empty($settings['tj_btn_text']) ? $settings['tj_btn_text'] : "";
$tjBtnLinkType = !empty($settings['tj_btn_link_type']) ? $settings['tj_btn_link_type'] : "";
$tjBtnLink = !empty($settings['tj_btn_link']) ? $settings['tj_btn_link'] : "";
$tjBtnPageLink = !empty($settings['tj_btn_page_link']) ? $settings['tj_btn_page_link'] : "";

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
  $this->add_render_attribute('tj-button-arg', 'rel', 'nofollow');
  $this->add_render_attribute('tj-button-arg', 'class', "price-button tj-bordered-btn");
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj-button-arg', $tjBtnLink);
    $this->add_render_attribute('tj-button-arg', 'class', "price-button tj-bordered-btn");
  }
}

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$priceBoxClass = "pricing__box price-el-box $isRecommended";
if (!empty($tjAnimation)) {
  $priceBoxClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-price-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-price-arg', 'class', $priceBoxClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-price-arg'); ?>>
  <?php if (!empty($isRecommended)): ?>
    <?php if (!empty($priceSubtitle)): ?>
      <div class="pricing__badge el-badge">
        <span><?php echo tj_kses($priceSubtitle); ?></span>
      </div>
    <?php endif; ?>
  <?php endif; ?>
  <div class="pricing__header price-el-header">
    <!-- title -->
    <?php if (!empty($priceTitle)): ?>
      <h4 class="pricing__package-name el-title"><?php echo tj_kses($priceTitle); ?></h4>
    <?php endif; ?>

    <!-- price -->
    <?php if (!empty($monthlyPrice) || !empty($yearlyPrice)): ?>
      <div class="pricing__package-price el-price">
        <span class="pricing__package-currency el-currency"><?php echo esc_attr($currency) ?></span>
        <span class="price-number" data-year-price="<?php echo esc_attr($yearlyPrice); ?>" data-month-price="<?php echo esc_attr($monthlyPrice); ?>"><?php echo esc_html($monthlyPrice, 'tjcore'); ?></span>
        <span class="pricing__package-period el-period period" data-year-period="<?php echo esc_attr($priceYearPeriod); ?>" data-month-period="<?php echo esc_attr($priceMonthPeriod); ?>"><?php echo esc_html__($priceMonthPeriod, 'tjcore'); ?></span>
      </div>
    <?php endif; ?>
    <!-- desc -->
    <?php if (!empty($priceDescription)): ?>
      <div class="pricing__package-desc el-desc">
        <p><?php echo tj_kses($priceDescription); ?></p>
      </div>
    <?php endif; ?>
  </div>
  <!-- features -->
  <?php if (!empty($featureList)): ?>
    <div class="pricing__features-list el-feature">
      <ul>
        <?php foreach ($featureList as $item):
          $icon = $item['tj_feature_icon'];
          $text = $item['tj_feature_text'];
          $available = $item['tj_feature_available'] === 'yes' ? 'hide' : 'active';
        ?>
          <li class="<?php echo esc_attr($available); ?>">
            <?php tj_render_icon($item, 'feature_icon', 'tj_feature_icon') ?>
            <?php echo esc_html__($text, 'tjcore'); ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>
  <?php if (!empty($tjBtnText)): ?>
    <div class="pricing__btn el-button <?php echo esc_attr($isRecommended); ?>">
      <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
        <span class="btn-text">
          <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
        </span>
        <?php if (!empty($settings['tj_btn_icon']['value'])): ?>
          <span class="btn-icon">
            <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
            <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
          </span>
        <?php endif; ?>
      </a>
    </div>
  <?php endif; ?>
</div>