<?php
$tjPricingContent = $settings['tj_pricing_content'] ?? "";
$id = $this->get_id();
?>

<?php if (!empty($tjPricingContent)): ?>
  <div class="h8-price-wrapper d-none d-lg-flex">
    <div class="price_tabs flex-column nav-pills" role="tablist" aria-orientation="vertical">
      <?php foreach ($tjPricingContent as $key => $content):

        $priceCurrency = $content['tj_price_currency'] ?? "";
        if ($priceCurrency === 'custom') {
          $currency = $content['currency_custom'];
        } else {
          $currency = self::get_currency_symbol($priceCurrency);
        }
      ?>
        <div class="tab_item <?php echo esc_attr($key == '0' ? 'active' : ''); ?>" data-bs-toggle="pill" data-bs-target="#priceTab-<?php echo esc_attr($id . '-' . $key); ?>" role="tab"
          aria-selected="<?php echo esc_attr($key == '0' ? 'true' : 'false'); ?>">
          <span class="checkbox"></span>

          <div class="content">
            <h4 class="title">
              <?php echo esc_html($content['price_title']); ?>
              <?php if (!empty($content['price_save'])): ?>
                <span><?php echo esc_html($content['price_save']); ?></span>
              <?php endif; ?>
            </h4>
            <?php if (!empty($content['price_desc'])): ?>
              <div class="desc"><?php echo tj_kses($content['price_desc']); ?></div>
            <?php endif; ?>
          </div>
          <div class="price">
            <?php if (!empty($currency)): ?>
              <span class="dollar"><?php echo esc_html($currency); ?></span>
            <?php endif; ?>
            <?php if (!empty($content['tj_monthly_price'])): ?>
              <span class="price-number" data-year-price="<?php echo esc_attr($content['tj_yearly_price']); ?>" data-month-price="<?php echo esc_attr($content['tj_monthly_price']); ?>">
                <?php echo esc_html($content['tj_monthly_price']); ?>
              </span>
            <?php endif; ?>
            <?php if (!empty($content['tj_month_price_period'])): ?>
              <span class="period" data-year-period="<?php echo esc_attr($content['tj_year_price_period']); ?>" data-month-period="<?php echo esc_attr($content['tj_month_price_period']); ?>">
                <?php echo esc_html($content['tj_month_price_period']); ?>
              </span>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <div class="price_tab_contents tab-content">

      <?php foreach ($tjPricingContent as $key => $content): ?>
        <div class="tab_content tab-pane  <?php echo esc_attr($key == '0' ? 'show active' : ''); ?>" id="priceTab-<?php echo esc_attr($id . '-' . $key); ?>" role="tabpanel">

          <?php if ('yes' == $content['is_price_box_recommend']): ?>
            <div class="pricing-badge"><?php echo esc_html($content['recommend_text']); ?></div>
          <?php endif; ?>

          <?php if (!empty($content['tj_price_features'])): ?>
            <div class="features">
              <?php echo tj_kses($content['tj_price_features']); ?>
            </div>
          <?php endif; ?>

          <div class="buttons">
            <?php if (!empty($content['tj_btn1_text'])):

              $tjBtnLinkType = $content['tj_btn1_link_type'] ?? "";
              $tjBtnLink = $content['tj_btn1_link'] ?? "";
              $tjBtnPageLink = $content['tj_btn1_page_link'] ?? "";

              if ('2' == $tjBtnLinkType) {
                $this->add_render_attribute('tj-button-arg-' . $key, 'href', get_permalink($tjBtnPageLink));
                $this->add_render_attribute('tj-button-arg-' . $key, 'target', '_self');
              } else {
                if (!empty($tjBtnLink['url'])) {
                  $this->add_link_attributes('tj-button-arg-' . $key, $tjBtnLink);
                }
              }
              $this->add_render_attribute('tj-button-arg-' . $key, 'class', "tj-primary-btn");
            ?>
              <a <?php $this->print_render_attribute_string('tj-button-arg-' . $key); ?>>
                <div class="btn_inner">
                  <div class="btn_icon">
                    <span>
                      <?php tj_render_icon($content, 'btn1_icon', 'tj_btn1_icon'); ?>
                      <?php tj_render_icon($content, 'btn1_icon', 'tj_btn1_icon'); ?>
                    </span>
                  </div>
                  <div class="btn_text">
                    <span><?php echo esc_html($content['tj_btn1_text']); ?></span>
                  </div>
                </div>
              </a>
            <?php endif; ?>

            <?php if (!empty($content['tj_btn2_text'])):

              $tjBtn2LinkType = $content['tj_btn2_link_type'] ?? "";
              $tjBtn2Link = $content['tj_btn2_link'] ?? "";
              $tjBtn2PageLink = $content['tj_btn2_page_link'] ?? "";

              if ('2' == $tjBtn2LinkType) {
                $this->add_render_attribute('tj-button2-arg-' . $key, 'href', get_permalink($tjBtn2PageLink));
                $this->add_render_attribute('tj-button2-arg-' . $key, 'target', '_self');
              } else {
                if (!empty($tjBtn2Link['url'])) {
                  $this->add_link_attributes('tj-button2-arg-' . $key, $tjBtn2Link);
                }
              }
              $this->add_render_attribute('tj-button2-arg-' . $key, 'class', "text-btn");
            ?>
              <a <?php $this->print_render_attribute_string('tj-button2-arg-' . $key); ?>>
                <?php echo esc_html($content['tj_btn2_text']); ?>
                <?php tj_render_icon($content, 'btn1_icon', 'tj_btn1_icon'); ?>
              </a>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="h8-price-mobile-wrapper d-lg-none" id="pricingAccordion-<?php echo esc_attr($id); ?>">

    <?php foreach ($tjPricingContent as $key => $content):

      $priceCurrency = $content['tj_price_currency'] ?? "";
      if ($priceCurrency === 'custom') {
        $currency = $content['currency_custom'];
      } else {
        $currency = self::get_currency_symbol($priceCurrency);
      }
    ?>
      <div class="pricing_a_item">
        <div class="tab_item <?php echo esc_attr($key == '0' ? ' ' : 'collapsed'); ?>" data-bs-toggle="collapse" data-bs-target="#priceA-<?php echo esc_attr($id . '-' . $key); ?>" aria-expanded="<?php echo esc_attr($key == '0' ? 'true' : 'false'); ?>">
          <div class="check_wrap"><span class="checkbox"></span></div>

          <div class="content">
            <h4 class="title">
              <?php echo esc_html($content['price_title']); ?>
              <?php if (!empty($content['price_save'])): ?>
                <span><?php echo esc_html($content['price_save']); ?></span>
              <?php endif; ?>
            </h4>
            <?php if (!empty($content['price_desc'])): ?>
              <div class="desc"><?php echo tj_kses($content['price_desc']); ?></div>
            <?php endif; ?>
          </div>
          <div class="price">
            <div>
              <?php if (!empty($currency)): ?>
                <span class="dollar"><?php echo esc_html($currency); ?></span>
              <?php endif; ?>
              <?php if (!empty($content['tj_monthly_price'])): ?>
                <span class="price-number" data-year-price="<?php echo esc_attr($content['tj_yearly_price']); ?>" data-month-price="<?php echo esc_attr($content['tj_monthly_price']); ?>">
                  <?php echo esc_html($content['tj_monthly_price']); ?>
                </span>
              <?php endif; ?>
            </div>
            <?php if (!empty($content['tj_month_price_period'])): ?>
              <span class="period" data-year-period="<?php echo esc_attr($content['tj_year_price_period']); ?>" data-month-period="<?php echo esc_attr($content['tj_month_price_period']); ?>">
                <?php echo esc_html($content['tj_month_price_period']); ?>
              </span>
            <?php endif; ?>
          </div>
        </div>

        <div id="priceA-<?php echo esc_attr($id . '-' . $key); ?>" class="pricing_a_content collapse <?php echo esc_attr($key == '0' ? 'show' : ''); ?>" data-bs-parent="#pricingAccordion-<?php echo esc_attr($id); ?>">
          <div class="tab_content accordion-body">
            <?php if ('yes' == $content['is_price_box_recommend']): ?>
              <div class="pricing-badge"><?php echo esc_html($content['recommend_text']); ?></div>
            <?php endif; ?>

            <?php if (!empty($content['tj_price_features'])): ?>
              <div class="features">
                <?php echo tj_kses($content['tj_price_features']); ?>
              </div>
            <?php endif; ?>

            <div class="buttons">
              <?php if (!empty($content['tj_btn1_text'])):

                $tjBtnLinkType = $content['tj_btn1_link_type'] ?? "";
                $tjBtnLink = $content['tj_btn1_link'] ?? "";
                $tjBtnPageLink = $content['tj_btn1_page_link'] ?? "";

                if ('2' == $tjBtnLinkType) {
                  $this->add_render_attribute('tj-button-arg-' . $key, 'href', get_permalink($tjBtnPageLink));
                  $this->add_render_attribute('tj-button-arg-' . $key, 'target', '_self');
                } else {
                  if (!empty($tjBtnLink['url'])) {
                    $this->add_link_attributes('tj-button-arg-' . $key, $tjBtnLink);
                  }
                }
                $this->add_render_attribute('tj-button-arg-' . $key, 'class', "tj-primary-btn");
              ?>
                <a <?php $this->print_render_attribute_string('tj-button-arg-' . $key); ?>>
                  <div class="btn_inner">
                    <div class="btn_icon">
                      <span>
                        <?php tj_render_icon($content, 'btn1_icon', 'tj_btn1_icon'); ?>
                        <?php tj_render_icon($content, 'btn1_icon', 'tj_btn1_icon'); ?>
                      </span>
                    </div>
                    <div class="btn_text">
                      <span><?php echo esc_html($content['tj_btn1_text']); ?></span>
                    </div>
                  </div>
                </a>
              <?php endif; ?>

              <?php if (!empty($content['tj_btn2_text'])):

                $tjBtn2LinkType = $content['tj_btn2_link_type'] ?? "";
                $tjBtn2Link = $content['tj_btn2_link'] ?? "";
                $tjBtn2PageLink = $content['tj_btn2_page_link'] ?? "";

                if ('2' == $tjBtn2LinkType) {
                  $this->add_render_attribute('tj-button2-arg-' . $key, 'href', get_permalink($tjBtn2PageLink));
                  $this->add_render_attribute('tj-button2-arg-' . $key, 'target', '_self');
                } else {
                  if (!empty($tjBtn2Link['url'])) {
                    $this->add_link_attributes('tj-button2-arg-' . $key, $tjBtn2Link);
                  }
                }
                $this->add_render_attribute('tj-button2-arg-' . $key, 'class', "text-btn");
              ?>
                <a <?php $this->print_render_attribute_string('tj-button2-arg-' . $key); ?>>
                  <?php echo esc_html($content['tj_btn2_text']); ?>
                  <?php tj_render_icon($content, 'btn1_icon', 'tj_btn1_icon'); ?>
                </a>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>