<?php
$processSteps = $settings["process_steps"] ?? [];
$tjTitleTag = $settings['tj_title_tag'] ?? "";

$this->add_render_attribute('title_args', 'class', 'title');
?>

<div class="h5-process_wrap">
  <?php if (!empty($processSteps)):

    foreach ($processSteps as $key => $step):

      $tjAnimation      = $step['tj_animation'] ?? '';
      $tjAnimationName  = $step['tj_animation_name'] ?? '';
      $tjAnimationDelay   = $step['tj_animation_delay'] ?? '';

      $process_arg = 'tj-process-arg-' . $key;
      $processClass = "h5-process_item";
      if (!empty($tjAnimation)) {
        $processClass .= " wow $tjAnimationName";
        $this->add_render_attribute($process_arg, 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      }
      $this->add_render_attribute($process_arg, 'class', $processClass);
  ?>
      <div <?php $this->print_render_attribute_string($process_arg); ?>>
        <span class="line"></span>

        <?php if (!empty($step["tj_no"])): ?>
          <div class="step"><?php echo esc_html($step['tj_no']); ?></div>
        <?php endif; ?>

        <?php if (!empty($step["tj_title"])):
          printf(
            '<%1$s %2$s>%3$s</%1$s>',
            tag_escape($tjTitleTag),
            $this->get_render_attribute_string('title_args'),
            tj_kses($step['tj_title'])
          );
        endif; ?>

        <?php if (!empty($step["tj_content"])): ?>
          <div class="desc">
            <?php echo tj_kses($step['tj_content']); ?>
          </div>
        <?php endif; ?>
      </div>
  <?php endforeach;
  endif; ?>
</div>