<?php
$processSteps = $settings["process_steps"] ?? [];
$tjTitleTag = $settings['tj_title_tag'] ?? "";

$this->add_render_attribute('title_args', 'class', 'title');
?>

<div class="h7-process-inner">

  <?php if (!empty($processSteps)): ?>
    <div class="process-line">
      <div class="process-line-active"></div>
    </div>

    <?php foreach ($processSteps as $key => $step):

      $tjAnimation      = $step['tj_animation'] ?? '';
      $tjAnimationName  = $step['tj_animation_name'] ?? '';
      $tjAnimationDelay   = $step['tj_animation_delay'] ?? '';

      $process_arg = 'tj-process-arg-' . $key;
      $processClass = "h7-process-item style-4";
      if (!empty($tjAnimation)) {
        $processClass .= " wow $tjAnimationName";
        $this->add_render_attribute($process_arg, 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      }
      $this->add_render_attribute($process_arg, 'class', $processClass);
    ?>
      <div <?php $this->print_render_attribute_string($process_arg); ?>>
        <?php if (!empty($step["tj_no"])): ?>
          <div class="process-index">
            <span><?php echo esc_html($step['tj_no']); ?></span>
          </div>
        <?php endif; ?>

        <div class="process-content">
          <?php if (!empty($step["tj_title"])):
            printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($tjTitleTag),
              $this->get_render_attribute_string('title_args'),
              tj_kses($step['tj_title'])
            );
          endif; ?>

          <?php if (!empty($step["tj_content"])): ?>
            <div class="desc">
              <p><?php echo tj_kses($step['tj_content']); ?></p>
            </div>
          <?php endif; ?>

          <?php if (!empty($step["tj_btn_text"])): ?>
            <a class="service-button text-btn" href="<?php echo esc_attr($step['tj_btn_link']); ?>">
              <?php echo esc_html($step['tj_btn_text']); ?>
              <?php tj_render_icon($step, "btn_icon", "tj_btn_icon"); ?>
            </a>
          <?php endif; ?>
        </div>
      </div>
  <?php endforeach;
  endif; ?>

</div>