<?php

$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "";
// animation
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "title text-anim";
} else {
  $titleClass = "title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

$tjShowContent   = !empty($settings['is_content']) ? "yes" : "no";
$tjSectionContent   = $settings['tj_content'] ?? "";
// animation
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';
if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('content_args', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('content_args', 'class', $contentClass);


$progressList = !empty($settings['tj_progress_list']) ? $settings['tj_progress_list'] : [];

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $progressClass = "tj-progress-bar wow $tjAnimationName";
  $this->add_render_attribute('tj-progress-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $progressClass = "tj-progress-bar";
}
$this->add_render_attribute('tj-progress-arg', 'class', $progressClass);
?>

<div class="skill-wrapper skill-el-wrap">
  <?php
  if (!empty($tjSectionTitle)) :
    printf(
      '<%1$s %2$s>%3$s</%1$s>',
      tag_escape($tjSectionTitleTag),
      $this->get_render_attribute_string('title_args'),
      tj_kses($tjSectionTitle)
    );
  endif;
  ?>
  <?php if ("yes" == $tjShowContent) : ?>
    <div <?php echo $this->get_render_attribute_string('content_args'); ?>>
      <?php echo tj_kses($tjSectionContent); ?>
    </div>
  <?php endif; ?>
  <?php if (!empty($progressList)): ?>
    <div <?php echo $this->get_render_attribute_string('tj-progress-arg'); ?>>
      <ul class="tj-progress__list style-2 mt-0">
        <?php foreach ($progressList as $key => $progress):
          $title = $progress['tj_progress_title'];
          $number = $progress['tj_progress'];
        ?>
          <li>
            <?php if (!empty($title)): ?>
              <h6 class="tj-progress__title el-title"><?php echo esc_html__($title, 'tjcore'); ?></h6>
            <?php endif; ?>
            <?php if (!empty($number)): ?>
              <div class="tj-progress">
                <div class="tj-progress__bar" data-perchant="<?php echo esc_attr($number['size']); ?>"><span class="tj-progress__perchant"><?php echo esc_attr($number['size'] . $number['unit']); ?></span></div>
              </div>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>
</div>