<?php

$progressList = !empty($settings['tj_progress_list']) ? $settings['tj_progress_list'] : [];


// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $progressClass = "tj-progress-bar skill-el-wrap wow $tjAnimationName";
  $this->add_render_attribute('tj-progress-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $progressClass = "tj-progress-bar skill-el-wrap";
}
$this->add_render_attribute('tj-progress-arg', 'class', $progressClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-progress-arg'); ?>>
  <?php if (!empty($progressList)): ?>
    <div <?php echo $this->get_render_attribute_string('tj-progress-arg'); ?>>
      <ul class="tj-progress__list">
        <?php foreach ($progressList as $key => $progress):
          $title = $progress['tj_progress_title'];
          $number = $progress['tj_progress'];
        ?>
          <li>
            <?php if (!empty($title)): ?>
              <h6 class="tj-progress__title el-title"><?php echo esc_html__($title, 'tjcore'); ?></h6>
            <?php endif; ?>
            <?php if (!empty($number)): ?>
              <div class="tj-progress">
                <div class="tj-progress__bar" data-perchant="<?php echo esc_attr($number['size']); ?>"><span class="tj-progress__perchant"><?php echo esc_attr($number['size'] . $number['unit']); ?></span></div>
              </div>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>
</div>