<?php

$progressList = !empty($settings['tj_progress_list']) ? $settings['tj_progress_list'] : [];


// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $progressClass = "progress-style-2 skill-el-wrap wow $tjAnimationName";
  $this->add_render_attribute('tj-progress-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $progressClass = "progress-style-2 skill-el-wrap";
}
$this->add_render_attribute('tj-progress-arg', 'class', $progressClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-progress-arg'); ?>>
  <?php if (!empty($progressList)): ?>
    <?php foreach ($progressList as $key => $progress):
      $title = $progress['tj_progress_title'];
      $number = $progress['tj_progress'];
      $width = $progress['tj_progress_width'];
      $height = $progress['tj_progress_height'];
      $color = $progress['progress_bg_color'] ?? '#0075FF';
    ?>
      <div class="proggess-item">
        <?php if (!empty($number)): ?>
          <div class="proggess-circle">
            <input type="text" class="knob" value="0" data-rel="<?php echo esc_attr($number['size']); ?>" data-linecap="0"
              data-width="<?php echo esc_attr($width); ?>" data-height="<?php echo esc_attr($height); ?>" data-bgcolor="#0075ff1a" data-fgcolor="<?php echo esc_attr($color); ?>"
              data-thickness=".12" data-readonly="true" disabled>
          </div>
        <?php endif; ?>
        <?php if (!empty($title)): ?>
          <div class="proggess-text">
            <span class="sub-title el-title"><?php echo esc_html__($title, 'tjcore'); ?></span>
          </div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>