<?php

$tj_project_list = !empty($settings['tj_project_list']) ? $settings['tj_project_list'] : [];

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $wrapClass = "project-wrapper-two wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $wrapClass = "project-wrapper-two";
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrapClass);

?>

<!-- start: Project Section -->
<?php if (!empty($tj_project_list)): ?>
  <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
    <?php foreach ($tj_project_list as $project):

      $projectImage = !empty($project['tj_project_image']) ? $project['tj_project_image'] : "";
      $projectTitle = !empty($project['tj_project_title']) ? $project['tj_project_title'] : "";
      $projectDesc = !empty($project['tj_project_desc']) ? $project['tj_project_desc'] : "";
      $projectCat = !empty($project['tj_project_cat']) ? $project['tj_project_cat'] : "";
      $projectCat2 = !empty($project['tj_project_cat2']) ? $project['tj_project_cat2'] : "";
      $projectBtn = !empty($project['tj_project_btn']) ? $project['tj_project_btn'] : "";
      $projectIcon = !empty($project['tj_pbtn_icon']) ? $project['tj_pbtn_icon'] : "";

      $link = !empty($project['tj_project_link']['url']) ? $project['tj_project_link']['url'] : '';
      $target = !empty($project['tj_project_link']['is_external']) ? '_blank' : '';
      $rel = !empty($project['tj_project_link']['nofollow']) ? 'nofollow' : '';

      $catlink = !empty($project['tj_cat_link']['url']) ? $project['tj_cat_link']['url'] : '';
      $catlink2 = !empty($project['tj_cat_link2']['url']) ? $project['tj_cat_link2']['url'] : '';

      $active   = !empty($project['tj_project_show']) ? 'active' : '';

    ?>
      <div class="project-style-3 <?php echo esc_attr($active); ?>">
        <div class="project-thumb">
          <?php if (!empty($projectImage['url'])): ?>
            <div class="image">
              <img src="<?php echo esc_url($projectImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($projectImage['id'], '_wp_attachment_image_alt', true)); ?>">
            </div>
          <?php endif; ?>
          <div class="project-default-content">
            <?php if (!empty($projectIcon['value'])) : ?>
              <span><?php tj_render_icon($project, 'tj_pbtn_icon', 'pbtn_icon'); ?></span>
            <?php endif; ?>
            <?php if (!empty($projectTitle)): ?>
              <h3 class="title"><?php echo esc_html($projectTitle); ?></h3>
            <?php endif; ?>
          </div>
        </div>
        <div class="project-content-box">
          <?php if (!empty($projectCat) || !empty($projectCat2)): ?>
            <div class="project-tags">
              <ul>
                <?php if (!empty($projectCat)): ?>
                  <li><a href="<?php echo esc_url($catlink); ?>"><?php echo esc_html($projectCat); ?></a></li>
                <?php endif; ?>
                <?php if (!empty($projectCat2)): ?>
                  <li><a href="<?php echo esc_url($catlink2); ?>"><?php echo esc_html($projectCat2); ?></a></li>
                <?php endif; ?>
              </ul>
            </div>
          <?php endif; ?>

          <div class="project-text">
            <?php if (!empty($projectTitle)): ?>
              <h3 class="title">
                <?php
                if (!empty($link)) :
                  $href = 'href="' . esc_attr($link) . '"';
                  $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                  $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                ?>
                  <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                    <?php echo esc_html($projectTitle); ?>
                  </a>
                <?php else: ?>
                  <?php echo esc_html($projectTitle); ?>
                <?php endif; ?>
              </h3>
            <?php endif; ?>
            <?php if (!empty($projectDesc)): ?>
              <div class="desc">
                <?php echo tj_kses($projectDesc); ?>
              </div>
            <?php endif; ?>
            <?php if (!empty($projectBtn)): ?>
              <div class="project-button">
                <a class="project-btn text-btn" href="<?php echo esc_url($link); ?>">
                  <?php echo esc_html($projectBtn); ?>
                  <?php if (!empty($projectIcon['value'])) : ?>
                    <?php tj_render_icon($project, 'tj_pbtn_icon', 'pbtn_icon'); ?>
                  <?php endif; ?>
                </a>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>

<!-- end: Project Section -->