<?php

$tj_project_list = !empty($settings['tj_project_list']) ? $settings['tj_project_list'] : [];

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $wrapClass = "h6-project-wrap wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $wrapClass = "h6-project-wrap";
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrapClass);

?>

<!-- start: Project Section -->
<?php if (!empty($tj_project_list)): ?>

  <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
    <?php foreach ($tj_project_list as $key => $project):

      $projectImage = !empty($project['tj_project_image']) ? $project['tj_project_image'] : "";
      $projectTitle = !empty($project['tj_project_title']) ? $project['tj_project_title'] : "";
      $projectDesc = !empty($project['tj_project_desc']) ? $project['tj_project_desc'] : "";
      $projectBtn = !empty($project['tj_project_btn']) ? $project['tj_project_btn'] : "";
      $projectIcon = !empty($project['tj_pbtn_icon']) ? $project['tj_pbtn_icon'] : "";

      $link = !empty($project['tj_project_link']['url']) ? $project['tj_project_link']['url'] : '';
      $target = !empty($project['tj_project_link']['is_external']) ? '_blank' : '';
      $rel = !empty($project['tj_project_link']['nofollow']) ? 'nofollow' : '';

      $active   = !empty($project['tj_project_stack']) ? 'project-stack' : '';
      $number   = !empty($project['tj_project_number']) ?? '';

    ?>
      <div class="h6-project-item <?php echo esc_attr($active); ?>">
        <?php if (!empty($projectImage['url'])): ?>
          <div class="project_image">
            <img src="<?php echo esc_url($projectImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($projectImage['id'], '_wp_attachment_image_alt', true)); ?>">
          </div>
        <?php endif; ?>
        <div class="project_content">
          <div class="project_content_inner">
            <?php if (!empty($number)): ?>
              <span class="no"><?php echo str_pad($key + 1, 2, '0', STR_PAD_LEFT) . esc_html("."); ?></span>
            <?php endif; ?>
            <?php if (!empty($projectTitle)): ?>
              <h3 class="title">
                <?php
                if (!empty($link)) :
                  $href = 'href="' . esc_attr($link) . '"';
                  $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                  $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                ?>
                  <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                    <?php echo esc_html($projectTitle); ?>
                  </a>
                <?php else: ?>
                  <?php echo esc_html($projectTitle); ?>
                <?php endif; ?>
              </h3>
            <?php endif; ?>

            <?php if (!empty($projectDesc)): ?>
              <div class="desc">
                <?php echo tj_kses($projectDesc); ?>
              </div>
            <?php endif; ?>

            <?php if (!empty($link)): ?>
              <a class="icon-btn project_btn el-icon" href="<?php echo esc_url($link); ?>">
                <?php tj_render_icon($project, 'tj_pbtn_icon', 'pbtn_icon'); ?>
              </a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

<?php endif; ?>
<!-- end: Project Section -->