<?php
$tjProjectInfoList = $settings['project_info_list'] ?? [];
$tjSectionTitle = $settings['tj_section_title'] ?? '';

// animation
$tj_social_show   = $settings['tj_social_show'] ?? '';
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$class = "tj-sidebar-widget mb-0";
if (!empty($tjAnimation)) {
  $class .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_project_info_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_project_info_args', 'class', $class);

$post_url = get_the_permalink();

?>

<?php if (!empty($tjProjectInfoList)): ?>

  <div <?php echo $this->get_render_attribute_string('tj_project_info_args'); ?>>
    <?php if (!empty($tjSectionTitle)): ?>
      <h5 class="tj-sidebar-widget-title"><?php echo tj_kses($tjSectionTitle); ?></h5>
    <?php endif; ?>
    <div class="project_catagory">
      <ul>
        <?php foreach ($tjProjectInfoList as $item):
          $subtitle = $item['tj_project_info_subtitle'] ?? '';
          $title = $item['tj_project_info_title'] ?? '';
        ?>
          <li>
            <?php if (!empty($subtitle)): ?>
              <span class="first-child"><?php echo esc_html__($subtitle, 'tjcore'); ?></span>
            <?php endif; ?>
            <?php if (!empty($title)): ?>
              <span><?php echo tj_kses($title); ?></span>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
        <?php if (!empty($tj_social_show)): ?>
          <li>
            <span class="first-child"><?php echo esc_html__('Share', 'tjcore'); ?></span>
            <div class="share-socials">
              <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo esc_url($post_url); ?>" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a>
              <a href="https://pinterest.com/pin/create/button/?url=<?php echo esc_url($post_url); ?>" target="_blank"><i class="fa-brands fa-pinterest-p"></i></a>
              <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($post_url); ?>" target="_blank"><i class="fa-brands fa-facebook-f"></i></a>
              <a href="https://twitter.com/share?url=<?php echo esc_url($post_url); ?>" target="_blank"><i class="fa-brands fa-twitter"></i></a>
            </div>
          </li>
        <?php endif; ?>
      </ul>
    </div>
  </div>

<?php endif; ?>