<?php

$tj_project_list = !empty($settings['tj_project_list']) ? $settings['tj_project_list'] : [];

?>

<?php if (!empty($tj_project_list)): ?>
  <div class="h4-case-wrapper">
    <?php foreach ($tj_project_list as $key => $project):

      $projectImage = !empty($project['tj_project_image']) ? $project['tj_project_image'] : "";
      $projectTitle = !empty($project['tj_project_title']) ? $project['tj_project_title'] : "";
      $tj_view_btn = !empty($project['tj_view_btn']) ? $project['tj_view_btn'] : "";

      $link = !empty($project['tj_project_link']['url']) ? $project['tj_project_link']['url'] : '';
      $target = !empty($project['tj_project_link']['is_external']) ? '_blank' : '';
      $rel = !empty($project['tj_project_link']['nofollow']) ? 'nofollow' : '';

      $isExpand = $project['is_expand'];

    ?>
      <div class="case-item <?php echo esc_attr($isExpand === 'yes' ? 'active' : ''); ?>">
        <?php if (!empty($projectTitle)): ?>
          <div class="header">
            <span>
              <span class="number"><?php echo str_pad($key + 1, 2, '0', STR_PAD_LEFT) . esc_html("."); ?></span>
              <?php echo esc_html($projectTitle); ?>
            </span>
            <span class="icon <?php echo esc_attr($isExpand === 'yes' ? 'active' : ''); ?>"><i class="tji-arrow-bown"></i></span>
          </div>
        <?php endif; ?>
        <?php if (!empty($projectImage['url'])): ?>
          <div class="content slider-drag" data-text="<?php echo tj_kses($tj_view_btn); ?>">
            <?php if (!empty($link)):
              $href = 'href="' . esc_attr($link) . '"';
              $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
              $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
            ?>
              <a class="view-project" <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                <img src="<?php echo esc_url($projectImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($projectImage['id'], '_wp_attachment_image_alt', true)); ?>">
              </a>
            <?php endif; ?>
          </div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
<?php else :
  printf("%s", esc_html__("No projects available", 'tjcore'));
endif; ?>