<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

$args = array(
  'post_type' => 'projects',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// The Query
$query = new \WP_Query($args);

$tjQuery            = !empty($settings['tj_query_style']) ? $settings['tj_query_style'] : "";
$tjProjectsList     = !empty($settings['tj_project_list']) ? $settings['tj_project_list'] : [];

$nav            = !empty($settings['slide_nav']) ? $settings['slide_nav'] : 'no';
$loop            = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$autoplay        = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay        = !empty($settings['slide_autoplay_delay']) ? $settings['slide_autoplay_delay'] : '5000';

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';

if (!empty($tjAnimation)) {
  $projectClass = "tj_projects sw-carousel-project carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj-project-arg', 'class', $projectClass);
} else {
  $projectClass = "tj_projects carouselWrap";
  $this->add_render_attribute('tj-project-arg', 'class', $projectClass);
}

$swipeDirction = !empty($settings['gsap_swipe_direction']) ? $settings['gsap_swipe_direction'] : '';

$swipeWrapperClass = '';
if ($swipeDirction === 'right-swipe') {
  $swipeWrapperClass = 'rightSwipeWrap';
} elseif ($swipeDirction === 'left-swipe') {
  $swipeWrapperClass = 'leftSwipeWrap';
}

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

// Preview values
$preview_xs  = $settings['tj_xs_preview'] ?? '';
$preview_sm  = $settings['tj_sm_preview'] ?? '';
$preview_md  = $settings['tj_md_preview'] ?? '';
$preview_lg  = $settings['tj_lg_preview'] ?? '';
$preview_xl  = $settings['tj_xl_preview'] ?? '';
$preview_xxl = $settings['tj_xxl_preview'] ?? '';

// Space values
$space_xs  = $settings['tj_xs_space'] ?? '';
$space_sm  = $settings['tj_sm_space'] ?? '';
$space_md  = $settings['tj_md_space'] ?? '';
$space_lg  = $settings['tj_lg_space'] ?? '';
$space_xl  = $settings['tj_xl_space'] ?? '';
$space_xxl = $settings['tj_xxl_space'] ?? '';

$data_attrs = [
  'xxl' => $preview_xxl,
  'xl'  => $preview_xl,
  'lg'  => $preview_lg,
  'md'  => $preview_md,
  'sm'  => $preview_sm,
  'xs'  => $preview_xs,

  'space-xxl' => $space_xxl,
  'space-xl'  => $space_xl,
  'space-lg'  => $space_lg,
  'space-md'  => $space_md,
  'space-sm'  => $space_sm,
  'space-xs'  => $space_xs,
];

// Convert to HTML attributes string
$data_attr_str = '';
foreach ($data_attrs as $key => $val) {
  if ($val !== '') {
    $data_attr_str .= ' data-' . esc_attr($key) . '="' . esc_attr($val) . '"';
  }
}

?>

<!-- start: Project Area -->
<div <?php echo $this->get_render_attribute_string('tj-project-arg'); ?> data-loop="<?php echo $loop; ?>" data-nav="<?php echo $nav; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>" <?php echo $data_attr_str; ?>>

  <?php if ("2" == $tjQuery): ?>
    <div class="container-fluid">
      <?php if ($query->have_posts()): ?>
        <div class="project-slider-one">
          <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper project-slider swiper-container" id="projectCarousel-<?php echo $this->get_id(); ?>">
            <div class="swiper-wrapper <?php echo esc_attr($swipeWrapperClass); ?>">
              <?php while ($query->have_posts()): $query->the_post();

                $categories = get_the_terms(get_the_ID(), 'projects-cat');
              ?>
                <div class="swiper-slide <?php echo esc_attr($swipeDirction); ?>">
                  <div class="project-item">
                    <?php if (has_post_thumbnail()): ?>
                      <div class="project-image">
                        <a class="cursor-hide" href="<?php the_permalink(); ?>">
                          <?php the_post_thumbnail('full'); ?>
                        </a>
                      </div>
                    <?php endif; ?>
                    <div class="project-content">
                      <div class="project-title">
                        <h4 class="title">
                          <a href="<?php the_permalink(); ?>">
                            <?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?>
                            <i class="tji-arrow-right"></i>
                          </a>
                        </h4>
                      </div>
                      <?php if (!empty($categories)): ?>
                        <div class="tag-list">
                          <?php
                          $category_names = array();
                          foreach ($categories as $cat) {
                            $category_names[] = '<a href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a>';
                          }
                          echo implode(' ', $category_names);
                          ?>
                        </div>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              <?php endwhile;
              wp_reset_query(); ?>
            </div>
          </div>
          <div class="tj-cursor"><i class="tji-angle-left"></i><?php echo esc_html__('Drag', 'tjcore'); ?><i class="tji-angle-right"></i></div>
        </div>
      <?php else :
        printf("%s", esc_html__("No projects available", 'tjcore'));
      endif; ?>

      <?php if ("yes" == $nav): ?>
        <div class="row text-center d-md-none">
          <div class="col">
            <div class="swiper_navigations project-navigation ">
              <div class="navigation project-prev"><i class="tji-arrow-left"></i></div>
              <div class="navigation project-next"><i class="tji-arrow-right"></i></div>
            </div>
          </div>
        </div>
      <?php endif; ?>
    </div>
  <?php else: ?>
    <div class="container-fluid">
      <?php if (!empty($tjProjectsList)): ?>
        <div class="project-slider-one">
          <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper project-slider swiper-container" id="projectCarousel-<?php echo $this->get_id(); ?>">
            <div class="swiper-wrapper <?php echo esc_attr($swipeWrapperClass); ?>">
              <?php foreach ($tjProjectsList as $project):

                $projectImage = !empty($project['tj_project_image']) ? $project['tj_project_image'] : "";
                $projectTitle = !empty($project['tj_project_title']) ? $project['tj_project_title'] : "";
                $projectCat = !empty($project['tj_project_cat']) ? $project['tj_project_cat'] : "";
                $projectCat2 = !empty($project['tj_project_cat2']) ? $project['tj_project_cat2'] : "";

                $link = !empty($project['tj_project_link']['url']) ? $project['tj_project_link']['url'] : '';
                $target = !empty($project['tj_project_link']['is_external']) ? '_blank' : '';
                $rel = !empty($project['tj_project_link']['nofollow']) ? 'nofollow' : '';
                $catlink = !empty($project['tj_cat_link']['url']) ? $project['tj_cat_link']['url'] : '';
                $catlink2 = !empty($project['tj_cat_link2']['url']) ? $project['tj_cat_link2']['url'] : '';
              ?>
                <div class="swiper-slide <?php echo esc_attr($swipeDirction); ?>">
                  <div class="project-item">
                    <?php if (!empty($projectImage['url'])): ?>
                      <div class="project-image">
                        <a class="cursor-hide" href="<?php echo esc_url($link); ?>">
                          <img src="<?php echo esc_url($projectImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($projectImage['id'], '_wp_attachment_image_alt', true)); ?>">
                        </a>
                      </div>
                    <?php endif; ?>
                    <div class="project-content">
                      <?php if (!empty($projectTitle)): ?>
                        <div class="project-title">
                          <h4 class="title">
                            <?php
                            if (!empty($link)) :
                              $href = 'href="' . esc_attr($link) . '"';
                              $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                              $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                            ?>
                              <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                                <?php echo esc_html($projectTitle); ?> <i class="tji-arrow-right"></i>
                              </a>
                            <?php else: ?>
                              <?php echo esc_html($projectTitle); ?> <i class="tji-arrow-right"></i>
                            <?php endif; ?>
                          </h4>
                        </div>
                      <?php endif; ?>
                      <?php if (!empty($projectCat) || !empty($projectCat2)): ?>
                        <div class="tag-list">
                          <?php if (!empty($projectCat)): ?>
                            <a href="<?php echo esc_url($catlink); ?>"><?php echo esc_html($projectCat); ?></a>
                          <?php endif; ?>
                          <?php if (!empty($projectCat2)): ?>
                            <a href="<?php echo esc_url($catlink2); ?>"><?php echo esc_html($projectCat2); ?></a>
                          <?php endif; ?>
                        </div>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
          <div class="tj-cursor"><i class="tji-angle-left"></i><?php echo esc_html__('Drag', 'tjcore'); ?><i class="tji-angle-right"></i></div>
        </div>
      <?php else :
        printf("%s", esc_html__("No projects available", 'tjcore'));
      endif; ?>

      <?php if ("yes" == $nav): ?>
        <div class="row text-center d-md-none">
          <div class="col">
            <div class="swiper_navigations project-navigation ">
              <div class="navigation project-prev"><i class="tji-arrow-left"></i></div>
              <div class="navigation project-next"><i class="tji-arrow-right"></i></div>
            </div>
          </div>
        </div>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>
<!-- end: Project Area -->