<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

$args = array(
  'post_type' => 'projects',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// The Query
$query = new \WP_Query($args);

$tjQuery            = !empty($settings['tj_query_style']) ? $settings['tj_query_style'] : "";
$tjProjectsList     = !empty($settings['tj_project_list']) ? $settings['tj_project_list'] : [];

$loop            = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$dot            = !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no';
$autoplay        = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay        = !empty($settings['slide_autoplay_delay']) ? $settings['slide_autoplay_delay'] : '5000';

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';

if (!empty($tjAnimation)) {
  $projectClass = "tj_projects sw-carousel-project-5 carouselWrap wow $tjAnimationName";
  $this->add_render_attribute('tj-project-arg', 'class', $projectClass);
} else {
  $projectClass = "tj_projects carouselWrap";
  $this->add_render_attribute('tj-project-arg', 'class', $projectClass);
}

$swipeDirction = !empty($settings['gsap_swipe_direction']) ? $settings['gsap_swipe_direction'] : '';

$swipeWrapperClass = '';
if ($swipeDirction === 'right-swipe') {
  $swipeWrapperClass = 'rightSwipeWrap';
} elseif ($swipeDirction === 'left-swipe') {
  $swipeWrapperClass = 'leftSwipeWrap';
}

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

// Preview values
$preview_xs  = $settings['tj_xs_preview'] ?? '';
$preview_sm  = $settings['tj_sm_preview'] ?? '';
$preview_md  = $settings['tj_md_preview'] ?? '';
$preview_lg  = $settings['tj_lg_preview'] ?? '';
$preview_xl  = $settings['tj_xl_preview'] ?? '';
$preview_xxl = $settings['tj_xxl_preview'] ?? '';

// Space values
$space_xs  = $settings['tj_xs_space'] ?? '';
$space_sm  = $settings['tj_sm_space'] ?? '';
$space_md  = $settings['tj_md_space'] ?? '';
$space_lg  = $settings['tj_lg_space'] ?? '';
$space_xl  = $settings['tj_xl_space'] ?? '';
$space_xxl = $settings['tj_xxl_space'] ?? '';

$data_attrs = [
  'xxl' => $preview_xxl,
  'xl'  => $preview_xl,
  'lg'  => $preview_lg,
  'md'  => $preview_md,
  'sm'  => $preview_sm,
  'xs'  => $preview_xs,

  'space-xxl' => $space_xxl,
  'space-xl'  => $space_xl,
  'space-lg'  => $space_lg,
  'space-md'  => $space_md,
  'space-sm'  => $space_sm,
  'space-xs'  => $space_xs,
];

// Convert to HTML attributes string
$data_attr_str = '';
foreach ($data_attrs as $key => $val) {
  if ($val !== '') {
    $data_attr_str .= ' data-' . esc_attr($key) . '="' . esc_attr($val) . '"';
  }
}

?>

<!-- start: Project Area -->
<div <?php echo $this->get_render_attribute_string('tj-project-arg'); ?> data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dot; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>" <?php echo $data_attr_str; ?>>

  <?php if ("2" == $tjQuery): ?>
    <div class="h5-case-study-wrapper">
      <?php if ($query->have_posts()): ?>

        <div dir="<?php echo esc_attr($is_rtl); ?>" class="h5-case-study-slider swiper swiper-container" id="projectCarousel-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper <?php echo esc_attr($swipeWrapperClass); ?>">
            <?php while ($query->have_posts()): $query->the_post();

              $categories = get_the_terms(get_the_ID(), 'projects-cat');
            ?>
              <div class="swiper-slide h5-case-study-item <?php echo esc_attr($swipeDirction); ?>">
                <div class="h5-case-study-item-inner" data-bg-image="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>">
                  <div class="case-study-content">
                    <?php if (!empty($categories)): ?>
                      <div class="category">
                        <?php
                        $category_names = array();
                        foreach ($categories as $cat) {
                          $category_names[] = '<a href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a>';
                        }
                        echo implode(' ', $category_names);
                        ?>
                      </div>
                    <?php endif; ?>
                    <div class="case-study-text">
                      <h3 class="title">
                        <a href="<?php the_permalink(); ?>">
                          <?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?>
                        </a>
                      </h3>
                      <a class="icon-btn" href="<?php the_permalink(); ?>">
                        <i class="tji-arrow-right"></i>
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            <?php endwhile;
            wp_reset_query(); ?>
          </div>
          <?php if ("yes" == $dot): ?>
            <div class="swiper_pagination"></div>
          <?php endif; ?>
        </div>

      <?php else :
        printf("%s", esc_html__("No projects available", 'tjcore'));
      endif; ?>
    </div>

  <?php else: ?>
    <div class="h5-case-study-wrapper">
      <?php if (!empty($tjProjectsList)): ?>
        <div dir="<?php echo esc_attr($is_rtl); ?>" class="h5-case-study-slider swiper swiper-container" id="projectCarousel-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper <?php echo esc_attr($swipeWrapperClass); ?>">
            <?php foreach ($tjProjectsList as $project):

              $projectImage = !empty($project['tj_project_image']) ? $project['tj_project_image'] : "";
              $projectTitle = !empty($project['tj_project_title']) ? $project['tj_project_title'] : "";
              $projectCat = !empty($project['tj_project_cat']) ? $project['tj_project_cat'] : "";
              $projectCat2 = !empty($project['tj_project_cat2']) ? $project['tj_project_cat2'] : "";

              $link = !empty($project['tj_project_link']['url']) ? $project['tj_project_link']['url'] : '';
              $target = !empty($project['tj_project_link']['is_external']) ? '_blank' : '';
              $rel = !empty($project['tj_project_link']['nofollow']) ? 'nofollow' : '';
              $catlink = !empty($project['tj_cat_link']['url']) ? $project['tj_cat_link']['url'] : '';
              $catlink2 = !empty($project['tj_cat_link2']['url']) ? $project['tj_cat_link2']['url'] : '';
            ?>
              <div class="swiper-slide h5-case-study-item <?php echo esc_attr($swipeDirction); ?>">
                <div class="h5-case-study-item-inner" data-bg-image="<?php echo esc_url($projectImage['url']); ?>">
                  <div class="case-study-content">
                    <?php if (!empty($projectCat) || !empty($projectCat2)): ?>
                      <div class="category">
                        <?php if (!empty($projectCat)): ?>
                          <a href="<?php echo esc_url($catlink); ?>"><?php echo esc_html($projectCat); ?></a>
                        <?php endif; ?>
                        <?php if (!empty($projectCat2)): ?>
                          <a href="<?php echo esc_url($catlink2); ?>"><?php echo esc_html($projectCat2); ?></a>
                        <?php endif; ?>
                      </div>
                    <?php endif; ?>
                    <div class="case-study-text">
                      <?php if (!empty($projectTitle)): ?>
                        <h3 class="title">
                          <?php
                          if (!empty($link)) :
                            $href = 'href="' . esc_attr($link) . '"';
                            $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                            $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                          ?>
                            <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                              <?php echo esc_html($projectTitle); ?>
                            </a>
                          <?php else: ?>
                            <?php echo esc_html($projectTitle); ?>
                          <?php endif; ?>
                        </h3>
                      <?php endif; ?>
                      <?php
                      if (!empty($link)) :
                        $href = 'href="' . esc_attr($link) . '"';
                        $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                        $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                      ?>
                        <a class="icon-btn" <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                          <i class="tji-arrow-right"></i>
                        </a>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
          <?php if ("yes" == $dot): ?>
            <div class="swiper_pagination"></div>
          <?php endif; ?>
        </div>
      <?php else :
        printf("%s", esc_html__("No projects available", 'tjcore'));
      endif; ?>
    </div>
  <?php endif; ?>
</div>
<!-- end: Project Area -->