<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

$args = array(
  'post_type' => 'projects',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// The Query
$query = new \WP_Query($args);

$tjQuery            = !empty($settings['tj_query_style']) ? $settings['tj_query_style'] : "";
$tjProjectsList     = !empty($settings['tj_project_list']) ? $settings['tj_project_list'] : [];

$loop            = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$dot            = !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no';
$nav            = !empty($settings['slide_nav']) ? $settings['slide_nav'] : 'no';
$autoplay        = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay        = !empty($settings['slide_autoplay_delay']) ? $settings['slide_autoplay_delay'] : '5000';

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationNameDelay   = $settings['tj_animation_delay'] ?? '';

$projectClass = "h7-project-inner carouselWrap";
if (!empty($tjAnimation)) {
  $projectClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-project-arg', 'data-wow-delay', $tjAnimationNameDelay['size'] . "s");
}
$this->add_render_attribute('tj-project-arg', 'class', $projectClass);

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

?>

<div <?php $this->print_render_attribute_string('tj-project-arg'); ?> data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dot; ?>" data-nav="<?php echo $nav; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">

  <?php if ("2" == $tjQuery): ?>
    <div class="h7-case-study-slider-wrapper">

      <?php if ($query->have_posts()): ?>
        <div dir="<?php echo esc_attr($is_rtl); ?>" class="h7-case-study-slider swiper swiper-container" id="projectCarousel-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper">
            <?php while ($query->have_posts()): $query->the_post();

              $categories = get_the_terms(get_the_ID(), 'projects-cat');
            ?>
              <div class="swiper-slide h5-case-study-item">
                <div class="h5-case-study-item-inner" data-bg-image="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>">
                  <div class="case-study-content">
                    <div class="case-study-text">
                      <div class="project_content">

                        <h3 class="title">
                          <a href="<?php the_permalink(); ?>">
                            <?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?>
                          </a>
                        </h3>

                        <?php if (!empty($categories)): ?>
                          <ul class="category">
                            <?php
                            $category_names = array();
                            foreach ($categories as $cat) {
                              $category_names[] = '<li><a href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a></li>';
                            }
                            echo implode(' ', $category_names);
                            ?>
                          </ul>
                        <?php endif; ?>
                      </div>


                      <a class="icon-btn" href="<?php the_permalink(); ?>">
                        <i class="tji-arrow-right"></i>
                      </a>
                    </div>

                  </div>
                </div>
              </div>
            <?php endwhile;
            wp_reset_query(); ?>

          </div>

          <?php if ("yes" == $dot): ?>
            <div class="swiper_pagination"></div>
          <?php endif; ?>
        </div>
      <?php else :
        printf("%s", esc_html__("No projects available", 'tjcore'));
      endif; ?>

    </div>

  <?php else: ?>
    <div class="h7-case-study-slider-wrapper">

      <?php if (!empty($tjProjectsList)): ?>
        <div dir="<?php echo esc_attr($is_rtl); ?>" class="h7-case-study-slider swiper swiper-container" id="projectCarousel-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper">
            <?php foreach ($tjProjectsList as $project):

              $projectImage = !empty($project['tj_project_image']) ? $project['tj_project_image'] : "";
              $projectTitle = !empty($project['tj_project_title']) ? $project['tj_project_title'] : "";
              $projectCat = !empty($project['tj_project_cat']) ? $project['tj_project_cat'] : "";
              $projectCat2 = !empty($project['tj_project_cat2']) ? $project['tj_project_cat2'] : "";

              $link = !empty($project['tj_project_link']['url']) ? $project['tj_project_link']['url'] : '';
              $target = !empty($project['tj_project_link']['is_external']) ? '_blank' : '';
              $rel = !empty($project['tj_project_link']['nofollow']) ? 'nofollow' : '';
              $catlink = !empty($project['tj_cat_link']['url']) ? $project['tj_cat_link']['url'] : '';
              $catlink2 = !empty($project['tj_cat_link2']['url']) ? $project['tj_cat_link2']['url'] : '';
            ?>
              <div class="swiper-slide h5-case-study-item">
                <div class="h5-case-study-item-inner" data-bg-image="<?php echo esc_url($projectImage['url']); ?>">
                  <div class="case-study-content">
                    <div class="case-study-text">
                      <div class="project_content">

                        <?php if (!empty($projectTitle)): ?>
                          <h3 class="title">
                            <?php
                            if (!empty($link)) :
                              $href = 'href="' . esc_attr($link) . '"';
                              $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                              $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                            ?>
                              <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                                <?php echo esc_html($projectTitle); ?>
                              </a>
                            <?php else: ?>
                              <?php echo esc_html($projectTitle); ?>
                            <?php endif; ?>
                          </h3>
                        <?php endif; ?>

                        <?php if (!empty($projectCat) || !empty($projectCat2)): ?>
                          <ul class="category">
                            <?php if (!empty($projectCat)): ?>
                              <li><a href="<?php echo esc_url($catlink); ?>"><?php echo esc_html($projectCat); ?></a></li>
                            <?php endif; ?>
                            <?php if (!empty($projectCat2)): ?>
                              <li><a href="<?php echo esc_url($catlink2); ?>"><?php echo esc_html($projectCat2); ?></a></li>
                            <?php endif; ?>
                          </ul>
                        <?php endif; ?>
                      </div>

                      <?php
                      if (!empty($link)) :
                        $href = 'href="' . esc_attr($link) . '"';
                        $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                        $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                      ?>
                        <a class="icon-btn" <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                          <i class="tji-arrow-right"></i>
                        </a>
                      <?php endif; ?>
                    </div>

                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>

          <?php if ("yes" == $dot): ?>
            <div class="swiper_pagination"></div>
          <?php endif; ?>
        </div>
      <?php else :
        printf("%s", esc_html__("No projects available", 'tjcore'));
      endif; ?>

    </div>
  <?php endif; ?>

  <?php if ("yes" == $nav): ?>
    <div class="tj-project-nav tj-project-nav-prev"><i class="tji-arrow-left"></i></div>
    <div class="tj-project-nav tj-project-nav-next"><i class="tji-arrow-right"></i></div>
  <?php endif; ?>
</div>