<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}

$args = array(
  'post_type' => 'projects',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// The Query
$query = new \WP_Query($args);

$tjQuery            = !empty($settings['tj_query_style']) ? $settings['tj_query_style'] : "";
$tjProjectsList     = !empty($settings['tj_project_list']) ? $settings['tj_project_list'] : [];

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';

if (!empty($tjAnimation)) {
  $projectClass = "project-item wow $tjAnimationName";
  $this->add_render_attribute('tj-project-arg', 'class', $projectClass);
} else {
  $projectClass = "project-item";
  $this->add_render_attribute('tj-project-arg', 'class', $projectClass);
}
?>

<!-- start: Project Area -->
<div class="tj-project-area">
  <?php if ("2" == $tjQuery): ?>
    <div class="row rg-30">
      <?php if ($query->have_posts()): ?>

        <?php while ($query->have_posts()): $query->the_post();

          $categories = get_the_terms(get_the_ID(), 'projects-cat');
        ?>
          <div class="col-xl-<?php echo esc_attr($desktop_column); ?> col-lg-<?php echo esc_attr($laptop_column); ?> col-md-<?php echo esc_attr($tablet_column); ?> col-<?php echo esc_attr($mobile_column); ?>">
            <div <?php echo $this->get_render_attribute_string('tj-project-arg'); ?>>
              <?php if (has_post_thumbnail()): ?>
                <div class="project-image">
                  <a class="cursor-hide" href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail('full'); ?>
                  </a>
                </div>
              <?php endif; ?>
              <div class="project-content">
                <div class="project-title">
                  <h4 class="title">
                    <a href="<?php the_permalink(); ?>">
                      <?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?>
                      <i class="tji-arrow-right"></i>
                    </a>
                  </h4>
                </div>
                <?php if (!empty($categories)): ?>
                  <div class="tag-list">
                    <?php
                    $category_names = array();
                    foreach ($categories as $cat) {
                      $category_names[] = '<a href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a>';
                    }
                    echo implode(' ', $category_names);
                    ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endwhile;
        wp_reset_query(); ?>

      <?php else :
        printf("%s", esc_html__("No projects available", 'tjcore'));
      endif; ?>
    </div>
    <?php if (!empty($tj_pagination)): ?>
      <div class="tj-pagination d-flex justify-content-center">
        <?php
        $prev = '<i class="tji-arrow-left"></i>';
        $next = '<i class="tji-arrow-right"></i>';
        $pagination = array(
          'base'      => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
          'format'    => '?paged=%#%',
          'current'   => max(1, get_query_var('paged')),
          'total'     => $query->max_num_pages,
          'prev_text' => $prev,
          'next_text' => $next,
          'type'      => 'list',
          'end_size'  => 3,
          'mid_size'  => 3
        );
        // Generate pagination links
        $return =  paginate_links($pagination);
        echo str_replace("<ul class='page-numbers'>", '<ul class="page-pagination">', $return);
        ?>
      </div>
    <?php endif; ?>
  <?php else: ?>
    <div class="row rg-30">
      <?php if (!empty($tjProjectsList)): ?>
        <?php foreach ($tjProjectsList as $project):
          $projectImage = !empty($project['tj_project_image']) ? $project['tj_project_image'] : "";
          $projectTitle = !empty($project['tj_project_title']) ? $project['tj_project_title'] : "";
          $projectCat = !empty($project['tj_project_cat']) ? $project['tj_project_cat'] : "";
          $projectCat2 = !empty($project['tj_project_cat2']) ? $project['tj_project_cat2'] : "";

          $link = !empty($project['tj_project_link']['url']) ? $project['tj_project_link']['url'] : '';
          $target = !empty($project['tj_project_link']['is_external']) ? '_blank' : '';
          $rel = !empty($project['tj_project_link']['nofollow']) ? 'nofollow' : '';
          $catlink = !empty($project['tj_cat_link']['url']) ? $project['tj_cat_link']['url'] : '';
          $catlink2 = !empty($project['tj_cat_link2']['url']) ? $project['tj_cat_link2']['url'] : '';
        ?>
          <div class="col-xl-<?php echo esc_attr($desktop_column); ?> col-lg-<?php echo esc_attr($laptop_column); ?> col-md-<?php echo esc_attr($tablet_column); ?> col-<?php echo esc_attr($mobile_column); ?>">
            <div <?php echo $this->get_render_attribute_string('tj-project-arg'); ?>>
              <?php if (!empty($projectImage['url'])): ?>
                <div class="project-image">
                  <a class="cursor-hide" href="<?php echo esc_url($link); ?>">
                    <img src="<?php echo esc_url($projectImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($projectImage['id'], '_wp_attachment_image_alt', true)); ?>">
                  </a>
                </div>
              <?php endif; ?>
              <div class="project-content">
                <?php if (!empty($projectTitle)): ?>
                  <div class="project-title">
                    <h4 class="title">
                      <?php
                      if (!empty($link)) :
                        $href = 'href="' . esc_attr($link) . '"';
                        $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                        $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                      ?>
                        <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                          <?php echo esc_html($projectTitle); ?> <i class="tji-arrow-right"></i>
                        </a>
                      <?php else: ?>
                        <?php echo esc_html($projectTitle); ?> <i class="tji-arrow-right"></i>
                      <?php endif; ?>
                    </h4>
                  </div>
                <?php endif; ?>
                <?php if (!empty($projectCat) || !empty($projectCat2)): ?>
                  <div class="tag-list">
                    <?php if (!empty($projectCat)): ?>
                      <a href="<?php echo esc_url($catlink); ?>"><?php echo esc_html($projectCat); ?></a>
                    <?php endif; ?>
                    <?php if (!empty($projectCat2)): ?>
                      <a href="<?php echo esc_url($catlink2); ?>"><?php echo esc_html($projectCat2); ?></a>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>

      <?php else :
        printf("%s", esc_html__("No projects available", 'tjcore'));
      endif; ?>
    </div>
  <?php endif; ?>
</div>
<!-- end: Project Area -->