<?php

$tj_project_list = !empty($settings['tj_project_list']) ? $settings['tj_project_list'] : [];
$tj_marque_list = !empty($settings['tj_marque_list']) ? $settings['tj_marque_list'] : [];


$tjBtnText     = $settings['tj_btn_text'];
$tjBtnLinkType = $settings['tj_btn_link_type'];
$tjBtnLink     = $settings['tj_btn_link'];
$tjBtnPageLink = $settings['tj_btn_page_link'];

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $buttonClass = "tj-primary-btn white-btn wow $tjAnimationName";
  $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $buttonClass = "tj-primary-btn white-btn";
}

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj-button-arg', 'target', '_self');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj-button-arg', $tjBtnLink);
  }
}
$this->add_render_attribute('tj-button-arg', 'class', $buttonClass);


?>

<!-- start: Project Section -->
<section class="tj-project-section-two section-space">
  <?php if (!empty($tj_marque_show)): ?>
    <?php if (!empty($tj_marque_list)): ?>
      <!-- marquee -->
      <div class="marquee-slider-wrapper-two">
        <div class="marquee-slider-two">
          <div class="our-scrolling-ticker">
            <!-- Scrolling Ticker Start -->
            <div class="scrolling-ticker-box">
              <div class="scrolling-content">
                <?php foreach ($tj_marque_list as $item):
                  $marqueTitle = !empty($item['tj_marque_title']) ? $item['tj_marque_title'] : "";
                  $icon = !empty($item['tj_marque_icon']) ? $item['tj_marque_icon'] : '';
                ?>
                  <span>
                    <?php if (!empty($icon['value'])) : ?>
                      <?php tj_render_icon($item, 'marque_icon', 'tj_marque_icon') ?>
                    <?php endif; ?>
                    <?php echo tj_kses($marqueTitle, 'tjcore');  ?>
                  </span>
                <?php endforeach; ?>
              </div>
              <div class="scrolling-content">
                <?php foreach ($tj_marque_list as $item):
                  $marqueTitle = !empty($item['tj_marque_title']) ? $item['tj_marque_title'] : "";
                  $icon = !empty($item['tj_marque_icon']) ? $item['tj_marque_icon'] : '';
                ?>
                  <span>
                    <?php if (!empty($icon['value'])) : ?>
                      <?php tj_render_icon($item, 'marque_icon', 'tj_marque_icon') ?>
                    <?php endif; ?>
                    <?php echo tj_kses($marqueTitle, 'tjcore');  ?>
                  </span>
                <?php endforeach; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php endif; ?>
  <?php endif; ?>
  <div class="container">
    <div class="row">
      <div class="col-12">
        <?php if (!empty($tj_project_list)): ?>
          <div class="project-wrapper">
            <?php foreach ($tj_project_list as $key => $project):

              $projectImage = !empty($project['tj_project_image']) ? $project['tj_project_image'] : "";
              $projectTitle = !empty($project['tj_project_title']) ? $project['tj_project_title'] : "";
              $tj_view_btn = !empty($project['tj_view_btn']) ? $project['tj_view_btn'] : "";
              $projectCat = !empty($project['tj_project_cat']) ? $project['tj_project_cat'] : "";
              $projectCat2 = !empty($project['tj_project_cat2']) ? $project['tj_project_cat2'] : "";

              $link = !empty($project['tj_project_link']['url']) ? $project['tj_project_link']['url'] : '';
              $target = !empty($project['tj_project_link']['is_external']) ? '_blank' : '';
              $rel = !empty($project['tj_project_link']['nofollow']) ? 'nofollow' : '';

              $catlink = !empty($project['tj_cat_link']['url']) ? $project['tj_cat_link']['url'] : '';
              $catlink2 = !empty($project['tj_cat_link2']['url']) ? $project['tj_cat_link2']['url'] : '';


              $tjAnimation      = $project['tj_animation'] ?? '';
              $tjAnimationName  = $project['tj_animation_name'] ?? '';
              $tjAnimationDelay   = $project['tj_animation_delay'] ?? '';

              $project_arg = 'tj_project_arg-' . $key;
              if (!empty($tjAnimation)) {
                $class = "project-style-2 wow $tjAnimationName";
                $this->add_render_attribute($project_arg, 'data-wow-delay', $tjAnimationDelay['size'] . "s");
              } else {
                $class = "project-style-2";
              }
              $this->add_render_attribute($project_arg, 'class', $class);

            ?>
              <div <?php echo $this->get_render_attribute_string($project_arg); ?>>
                <?php if (!empty($projectImage['url'])): ?>
                  <div class="project-images">
                    <img src="<?php echo esc_url($projectImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($projectImage['id'], '_wp_attachment_image_alt', true)); ?>">
                    <?php if (!empty($tj_view_btn)): ?>
                      <a href="<?php echo esc_url($link); ?>"><?php echo esc_html($tj_view_btn); ?></a>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <div class="project-content">
                  <?php if (!empty($projectTitle)): ?>
                    <h4 class="title">
                      <?php
                      if (!empty($link)) :
                        $href = 'href="' . esc_attr($link) . '"';
                        $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                        $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                      ?>
                        <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                          <?php echo esc_html($projectTitle); ?>
                        </a>
                      <?php else: ?>
                        <?php echo esc_html($projectTitle); ?>
                      <?php endif; ?>
                    </h4>
                  <?php endif; ?>
                  <?php if (!empty($projectCat) || !empty($projectCat2)): ?>
                    <div class="project-category">
                      <ul>
                        <?php if (!empty($projectCat)): ?>
                          <li><a href="<?php echo esc_url($catlink); ?>"><?php echo esc_html($projectCat); ?></a></li>
                        <?php endif; ?>
                        <?php if (!empty($projectCat2)): ?>
                          <li><a href="<?php echo esc_url($catlink2); ?>"><?php echo esc_html($projectCat2); ?></a></li>
                        <?php endif; ?>
                      </ul>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php else :
          printf("%s", esc_html__("No projects available", 'tjcore'));
        endif; ?>

        <?php if (!empty($tjBtnText)) : ?>
          <div class="projects_button text-center">
            <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
              <span class="btn_inner">
                <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                  <span class="btn_icon">
                    <span>
                      <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                      <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                    </span>
                  </span>
                <?php endif; ?>
                <span class="btn_text">
                  <span>
                    <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
                  </span>
                </span>
              </span>
            </a>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>
<!-- end: Project Section -->