<?php
$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);


$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjGsapAnimationType   = $settings['animation_type'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';

$gsapAnimation = ("tj-text-invert" == $tjGsapAnimationType) ? "tj-text-invert" : "text-anim";

if (!empty($tjTitleAnimation)) {
  $titleClass = "sec-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif ($tj_gsap_animation) {
  $titleClass = "sec-title $gsapAnimation";
} else {
  $titleClass = "sec-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);


$tjShowContent   = !empty($settings['is_content']) ? "yes" : "no";
$tjSectionContent   = $settings['tj_content'] ?? "";
// animation
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';
if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('content_args', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('content_args', 'class', $contentClass);
?>

<div class="sec-heading">

  <?php if (!empty($tjSectionSubtitle)) : ?>
    <span <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
      <?php echo esc_html($tjSectionSubtitle); ?>
    </span>
  <?php endif; ?>

  <?php
  if (!empty($tjSectionTitle)) :
    printf(
      '<%1$s %2$s>%3$s</%1$s>',
      tag_escape($tjSectionTitleTag),
      $this->get_render_attribute_string('title_args'),
      tj_kses($tjSectionTitle)
    );
  endif;
  ?>

  <?php if ("yes" == $tjShowContent) : ?>
    <div <?php echo $this->get_render_attribute_string('content_args'); ?>>
      <?php echo tj_kses($tjSectionContent); ?>
    </div>
  <?php endif; ?>
</div>