<?php

$tj_service_list = !empty($settings['tj_service_list']) ? $settings['tj_service_list'] : [];

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$wrappClass = "service-wrapper-two";
if (!empty($tjAnimation)) {
  $wrappClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrappClass);


?>

<div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
  <?php foreach ($tj_service_list as $key => $service):

    $serviceImage = !empty($service['tj_service_image']) ? $service['tj_service_image'] : "";
    $serviceTitle = !empty($service['tj_service_title']) ? $service['tj_service_title'] : "";
    $serviceDesc = !empty($service['tj_service_desc']) ? $service['tj_service_desc'] : "";
    $serviceBtn = !empty($service['tj_service_btn']) ? $service['tj_service_btn'] : "";
    $serviceNum = !empty($service['tj_service_num']) ? $service['tj_service_num'] : "";

    $icon = !empty($service['service_icon_btn']) ? $service['service_icon_btn'] : '';

    $link = !empty($service['tj_service_link']['url']) ? $service['tj_service_link']['url'] : '';
    $target = !empty($service['tj_service_link']['is_external']) ? '_blank' : '';
    $rel = !empty($service['tj_service_link']['nofollow']) ? 'nofollow' : '';

  ?>
    <div class="service-style-3 wow fadeInUp" data-wow-delay="0.1s">

      <?php if (!empty($serviceImage['url'])): ?>
        <div class="service-image" data-bg-image="<?php echo esc_url($serviceImage['url']); ?>"></div>
      <?php endif; ?>

      <?php if (!empty($serviceTitle)): ?>
        <div class="service-title">
          <h4 class="title">
            <?php if (!empty($tj_number)): ?>
              <span><?php echo str_pad($key + 1, 2, '0', STR_PAD_LEFT) . esc_html("."); ?></span>
            <?php endif; ?>
            <?php
            if (!empty($link)) :
              $href = 'href="' . esc_attr($link) . '"';
              $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
              $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
            ?>
              <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                <?php echo tj_kses($serviceTitle); ?>
              </a>
            <?php else: ?>
              <?php echo tj_kses($serviceTitle); ?>
            <?php endif; ?>
          </h4>
        </div>
      <?php endif; ?>
      <?php if (!empty($serviceDesc)): ?>
        <div class="desc">
          <div><?php echo tj_kses($serviceDesc); ?></div>

          <?php if (!empty($serviceBtn)): ?>
            <div class="service-button d-lg-none">
              <a href="<?php echo esc_url($link); ?>" class="text-btn">
                <?php echo esc_html($serviceBtn); ?>
                <?php if (!empty($icon['value'])) : ?>
                  <?php tj_render_icon($service, 'btn_icon', 'service_icon_btn') ?>
                <?php endif; ?>
              </a>
            </div>
          <?php endif; ?>
        </div>
      <?php endif; ?>
      <?php if (!empty($serviceBtn)): ?>
        <div class="service-button d-none d-lg-inline-block">
          <a href="<?php echo esc_url($link); ?>" class="text-btn">
            <?php echo esc_html($serviceBtn); ?>
            <?php if (!empty($icon['value'])) : ?>
              <?php tj_render_icon($service, 'btn_icon', 'service_icon_btn') ?>
            <?php endif; ?>
          </a>
        </div>
      <?php endif; ?>
    </div>
  <?php endforeach; ?>
</div>